/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.json.page.PageClassificationHistoryJson;
import co.uk.automationconsultants.compliance.utils.JsonUtils;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Path(value="/optimize-history")
public class OptimizeHistoryPropertyRest {
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final ContentService contentService;
    @ComponentImport
    private final ContentPropertyService contentPropertyService;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;

    @Inject
    public OptimizeHistoryPropertyRest(SpaceManager spaceManager, PageManager pageManager, ContentService contentService, ContentPropertyService contentPropertyService, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager) {
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.contentService = contentService;
        this.contentPropertyService = contentPropertyService;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response optimizeHistoryProperty(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((int)403).build();
        }
        List spaces = this.spaceManager.getAllSpaces();
        for (Space space : spaces) {
            for (Page page : this.pageManager.getPages(space, true)) {
                ObjectMapper mapper = new ObjectMapper();
                JsonContentProperty existingHistory = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(page.getContentId()).withPropertyKey("classificationhistory").fetchOneOrNull();
                try {
                    if (existingHistory == null) continue;
                    PageClassificationHistoryJson[] pageClassificationHistoryJsons = (PageClassificationHistoryJson[])mapper.readValue(existingHistory.getValue().getValue(), PageClassificationHistoryJson[].class);
                    ArrayList<PageClassificationHistoryJson> optimizedHistoryJsons = new ArrayList<PageClassificationHistoryJson>();
                    int lastPoint = 0;
                    for (int i = 0; i < pageClassificationHistoryJsons.length; ++i) {
                        if (i == 0) {
                            optimizedHistoryJsons.add(pageClassificationHistoryJsons[i]);
                            lastPoint = i;
                            continue;
                        }
                        if (pageClassificationHistoryJsons[i].name.equals(pageClassificationHistoryJsons[lastPoint].name)) continue;
                        optimizedHistoryJsons.add(pageClassificationHistoryJsons[i]);
                        lastPoint = i;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    for (PageClassificationHistoryJson pageClassificationHistoryJson : optimizedHistoryJsons) {
                        stringBuilder.append(this.getPageClassificationHistoryString(pageClassificationHistoryJson)).append(",");
                    }
                    stringBuilder.setLength(stringBuilder.length() - 1);
                    Content content = (Content)this.contentService.find(new Expansion[0]).withId(page.getContentId()).fetchOneOrNull();
                    JsonContentProperty.ContentPropertyBuilder property = JsonContentProperty.builder().content(content).key("classificationhistory").value(new JsonString("[" + stringBuilder.toString() + "]"));
                    if (existingHistory == null) {
                        this.contentPropertyService.create(property.build());
                        continue;
                    }
                    Version currentVersion = existingHistory.getVersion();
                    this.contentPropertyService.update(property.version(Version.builder().number(currentVersion.getNumber() + 1).build()).build());
                }
                catch (IOException io) {
                    io.printStackTrace();
                }
            }
        }
        return Response.ok().build();
    }

    private String getPageClassificationHistoryString(PageClassificationHistoryJson json) {
        try {
            return JsonUtils.marshal(json);
        }
        catch (IOException e) {
            return null;
        }
    }
}

