/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.service.LogService;
import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@Path(value="/log")
@PublicApi
public class LogRest {
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final LogService logService;

    @Inject
    public LogRest(LogService logService, PermissionManager permissionManager, UserManager userManager, UserAccessor userAccessor) {
        this.logService = logService;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getLogs(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok(this.logService.getLogs(1000)).build();
    }

    @GET
    @Path(value="/actionLog")
    @Produces(value={"application/json"})
    public Response getActionLogs(@Context HttpServletRequest request, @QueryParam(value="actionId") Integer aId) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (aId != null) {
            return Response.ok(this.logService.getActionLog(aId)).build();
        }
        return Response.ok(this.logService.getActionLogs(1000)).build();
    }
}

