/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.cache.SpaceSettingsCache;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@Path(value="/invalidate-space")
public class InvalidateSpaceCacheRest {
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final SpaceManager spaceManager;
    private final SpaceSettingsCache spaceSettingsCache;

    @Inject
    public InvalidateSpaceCacheRest(UserManager userManager, UserAccessor userAccessor, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, SpaceSettingsCache spaceSettingsCache) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
        this.spaceSettingsCache = spaceSettingsCache;
    }

    @GET
    public Response invalidateSpaceCache(@Context HttpServletRequest request, @QueryParam(value="spaceKey") String spaceKey) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space != null && this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, user)) {
            this.spaceSettingsCache.invalidateCache(spaceKey);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

