/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.entity.extractions.ExtractionEntity;
import co.uk.automationconsultants.compliance.json.capture.ExtractionJson;
import co.uk.automationconsultants.compliance.json.capture.VerifyJson;
import co.uk.automationconsultants.compliance.json.capture.VerifyResultJson;
import co.uk.automationconsultants.compliance.service.ExtractionService;
import co.uk.automationconsultants.compliance.utils.ExtractionUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.DBParam;
import net.java.ao.Query;

@Path(value="/extraction")
public class ExtractionRest {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final ExtractionService extractionService;

    @Inject
    public ExtractionRest(ActiveObjects activeObjects, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, ExtractionService extractionService) {
        this.activeObjects = activeObjects;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.extractionService = extractionService;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getExtractions(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (user == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ExtractionUtils.createEntities(this.activeObjects);
        ExtractionEntity[] extractionEntities = (ExtractionEntity[])this.activeObjects.find(ExtractionEntity.class, Query.select().order("ICON ASC, NAME ASC"));
        Stream<ExtractionEntity> entities = Arrays.stream(extractionEntities);
        return Response.ok(entities.map(extractionEntity -> new ExtractionJson(extractionEntity.getID(), extractionEntity.getName(), extractionEntity.getDescription(), extractionEntity.getIcon(), extractionEntity.getRegEx(), extractionEntity.isEnabled(), extractionEntity.isSysDefined())).collect(Collectors.toList())).build();
    }

    @GET
    @Path(value="/external-detection")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getExternalDetectionExtractionId(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (user == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ExtractionEntity extractionEntity = ((ExtractionEntity[])this.activeObjects.find(ExtractionEntity.class, Query.select().where("NAME = ? AND SYS_DEFINED = ?", new Object[]{"External Detection", true})))[0];
        return Response.ok((Object)extractionEntity.getID()).build();
    }

    @Path(value="/verify")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response verifyRegEx(@Context HttpServletRequest request, VerifyJson verifyJson) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (user == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            Pattern pattern = Pattern.compile(verifyJson.getPattern());
            VerifyResultJson verifyResultJson = new VerifyResultJson();
            verifyResultJson.setPattern(verifyJson.pattern);
            verifyResultJson.setText(verifyJson.text);
            if (verifyJson.getText() != null && verifyJson.getText().length() > 0) {
                ArrayList<String> matches = new ArrayList<String>();
                long startTime = System.currentTimeMillis();
                Matcher matcher = pattern.matcher(verifyJson.getText());
                while (matcher.find()) {
                    matches.add(matcher.group(0));
                }
                verifyResultJson.setDuration(System.currentTimeMillis() - startTime);
                verifyResultJson.setResults(matches);
                return Response.ok().entity((Object)verifyResultJson).build();
            }
            return Response.ok().build();
        }
        catch (PatternSyntaxException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
    }

    @POST
    @WebSudoRequired
    @Produces(value={"application/json"})
    public Response updateExtraction(@Context HttpServletRequest request, ExtractionJson extractionJson, @QueryParam(value="index") int index) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ExtractionEntity item = (ExtractionEntity)this.activeObjects.get(ExtractionEntity.class, (Object)index);
        if (item == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.activeObjects.executeInTransaction(() -> {
            ExtractionEntity extractionEntity = (ExtractionEntity)this.activeObjects.get(ExtractionEntity.class, (Object)index);
            extractionEntity.setIcon(extractionJson.getIcon());
            extractionEntity.setName(extractionJson.getName());
            extractionEntity.setDescription(extractionJson.getDescription());
            extractionEntity.setRegEx(extractionJson.getRegEx());
            extractionEntity.save();
            return true;
        });
        return Response.ok().build();
    }

    @PUT
    @WebSudoRequired
    @Produces(value={"application/json"})
    public Response createExtraction(@Context HttpServletRequest request, ExtractionJson extractionJson) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.activeObjects.executeInTransaction(() -> {
            this.activeObjects.create(ExtractionEntity.class, new DBParam[]{new DBParam("NAME", (Object)extractionJson.getName()), new DBParam("DESCRIPTION", (Object)extractionJson.getDescription()), new DBParam("ICON", (Object)extractionJson.getIcon().toLowerCase()), new DBParam("REG_EX", (Object)extractionJson.getRegEx()), new DBParam("ENABLED", (Object)false), new DBParam("SYS_DEFINED", (Object)false)});
            return true;
        });
        return Response.ok().build();
    }

    @DELETE
    @WebSudoRequired
    @Produces(value={"application/json"})
    public Response deleteExtraction(@Context HttpServletRequest request, @QueryParam(value="index") int index) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ExtractionEntity extractionEntity = (ExtractionEntity)this.activeObjects.get(ExtractionEntity.class, (Object)index);
        if (extractionEntity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.extractionService.deleteExtraction(extractionEntity);
        return Response.ok().build();
    }

    @POST
    @Path(value="/status")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response changeExtractionStatus(@Context HttpServletRequest request, @QueryParam(value="id") int id, @QueryParam(value="status") boolean status) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ExtractionEntity extractionEntity = (ExtractionEntity)this.activeObjects.get(ExtractionEntity.class, (Object)id);
        if (extractionEntity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.activeObjects.executeInTransaction(() -> {
            extractionEntity.setEnabled(status);
            extractionEntity.save();
            return true;
        });
        return Response.ok().build();
    }

    @POST
    @Path(value="/maintenance")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response performMaintenance(@Context HttpServletRequest request) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            int invalidEntries = this.extractionService.performExtractionResultMaintenance();
            return Response.ok((Object)invalidEntries).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("{\"message\": \"%s\"}", e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/maintenance")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getInvalidEntries(@Context HttpServletRequest request) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            int invalidEntries = this.extractionService.getInvalidExtractionResultsSize();
            return Response.ok((Object)invalidEntries).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("{\"message\": \"%s\"}", e.getMessage())).build();
        }
    }
}

