/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.exception.externalapi.ExternalAPIResponseException;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigJson;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigPayload;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigReadOnly;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIRequest;
import co.uk.automationconsultants.compliance.service.externalapi.ExternalAPIService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.security.GeneralSecurityException;
import java.util.Objects;

@Path(value="/externalapi")
public class ExternalAPIConfigRest {
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final ExternalAPIService externalAPIService;

    @Inject
    public ExternalAPIConfigRest(PermissionManager permissionManager, UserManager userManager, UserAccessor userAccessor, ExternalAPIService externalAPIService) {
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.externalAPIService = externalAPIService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateConfig(@Context HttpServletRequest request, ExternalAPIConfigPayload payload) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            if (this.externalAPIService.hasBeenConfigured()) {
                ExternalAPIConfigReadOnly config = this.externalAPIService.updateAuthConfigReadOnly(payload);
                return Response.ok((Object)config).build();
            }
            ExternalAPIConfigJson config = this.externalAPIService.createConfig(payload);
            return Response.ok((Object)config.toReadOnly()).build();
        }
        catch (GeneralSecurityException e) {
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response getConfig(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ExternalAPIConfigReadOnly config = this.externalAPIService.getAuthConfigReadOnly();
        if (config == null) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)this.externalAPIService.getAuthConfigReadOnly()).build();
    }

    @POST
    @Path(value="/request")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendRestRequest(ExternalAPIRequest request) {
        try {
            return Response.ok((Object)this.externalAPIService.runExternalAPIRequest(request)).build();
        }
        catch (ExternalAPIResponseException e) {
            return Response.status((int)e.getStatusCode()).header("API-ERROR-MESSAGE", (Object)e.getMessage()).entity((Object)e.getResponseBody()).build();
        }
        catch (Exception e) {
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }
}

