/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.entity.automation.AutomationActionEntity;
import co.uk.automationconsultants.compliance.entity.automation.AutomationEntity;
import co.uk.automationconsultants.compliance.entity.automation.AutomationExtractionEntity;
import co.uk.automationconsultants.compliance.entity.automation.AutomationScopeEntity;
import co.uk.automationconsultants.compliance.entity.extractions.ExtractionEntity;
import co.uk.automationconsultants.compliance.json.action.AutomationActionJson;
import co.uk.automationconsultants.compliance.json.action.AutomationCreationJson;
import co.uk.automationconsultants.compliance.json.action.AutomationJson;
import co.uk.automationconsultants.compliance.json.request.AdHocChangeRequestJson;
import co.uk.automationconsultants.compliance.service.AutomationService;
import co.uk.automationconsultants.compliance.service.NotificationService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/automation")
public class AutomationRest {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final AutomationService automationService;
    private static final Logger log = LoggerFactory.getLogger(NotificationService.class);

    @Inject
    public AutomationRest(ActiveObjects activeObjects, SpaceManager spaceManager, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, AutomationService automationService) {
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.automationService = automationService;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getRules(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok(Arrays.stream((AutomationEntity[])this.activeObjects.find(AutomationEntity.class, Query.select().order("ID ASC"))).map(automationEntity -> AutomationJson.map(automationEntity, this.spaceManager)).collect(Collectors.toList())).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createRule(@Context HttpServletRequest request, AutomationCreationJson automationJson) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        AutomationJson rule = (AutomationJson)this.activeObjects.executeInTransaction(() -> {
            AutomationEntity newEntity = (AutomationEntity)this.activeObjects.create(AutomationEntity.class, new DBParam[]{new DBParam("NAME", (Object)automationJson.getName()), new DBParam("ENABLED", (Object)automationJson.getEnabled()), new DBParam("EXECUTIONS", (Object)0), new DBParam("CREATED_ON", (Object)new Date()), new DBParam("EXECUTION_USER", (Object)user.getName()), new DBParam("DETECTION_ENABLED", (Object)automationJson.getDetectionEnabled())});
            for (Integer extractionId : automationJson.getExtractions()) {
                if (this.activeObjects.get(ExtractionEntity.class, (Object)extractionId) == null) continue;
                this.activeObjects.create(AutomationExtractionEntity.class, new DBParam[]{new DBParam("AUTOMATION_ENTITY_ID", (Object)newEntity.getID()), new DBParam("EXTRACTION_ENTITY_ID", (Object)extractionId)});
            }
            for (String spaceKey : automationJson.getScope()) {
                if (this.spaceManager.getSpace(spaceKey) == null) continue;
                this.activeObjects.create(AutomationScopeEntity.class, new DBParam[]{new DBParam("AUTOMATION_ENTITY_ID", (Object)newEntity.getID()), new DBParam("SPACE_KEY", (Object)spaceKey)});
            }
            for (AutomationActionJson action : automationJson.getActions()) {
                switch (action.getType()) {
                    case "label": {
                        this.activeObjects.create(AutomationActionEntity.class, new DBParam[]{new DBParam("AUTOMATION_ENTITY_ID", (Object)newEntity.getID()), new DBParam("TYPE", (Object)action.getType()), new DBParam("LABEL", (Object)action.getLabel())});
                        break;
                    }
                    case "email": {
                        this.activeObjects.create(AutomationActionEntity.class, new DBParam[]{new DBParam("AUTOMATION_ENTITY_ID", (Object)newEntity.getID()), new DBParam("TYPE", (Object)action.getType()), new DBParam("USER", (Object)action.getUsers())});
                        break;
                    }
                    case "classify": {
                        this.activeObjects.create(AutomationActionEntity.class, new DBParam[]{new DBParam("AUTOMATION_ENTITY_ID", (Object)newEntity.getID()), new DBParam("TYPE", (Object)action.getType()), new DBParam("LEVEL", (Object)action.getLevel())});
                        break;
                    }
                    case "redact": {
                        this.activeObjects.create(AutomationActionEntity.class, new DBParam[]{new DBParam("AUTOMATION_ENTITY_ID", (Object)newEntity.getID()), new DBParam("TYPE", (Object)action.getType())});
                        break;
                    }
                }
            }
            return AutomationJson.map(newEntity, this.spaceManager);
        });
        return Response.ok((Object)rule).build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteRule(@Context HttpServletRequest request, @QueryParam(value="index") int index) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        AutomationEntity existingRule = (AutomationEntity)this.activeObjects.get(AutomationEntity.class, (Object)index);
        AutomationExtractionEntity[] automationExtractionEntities = (AutomationExtractionEntity[])this.activeObjects.find(AutomationExtractionEntity.class, Query.select().where("AUTOMATION_ENTITY_ID = ?", new Object[]{index}));
        this.activeObjects.delete((RawEntity[])automationExtractionEntities);
        AutomationActionEntity[] automationActionEntities = existingRule.getAutomationActionEntities();
        this.activeObjects.delete((RawEntity[])automationActionEntities);
        AutomationScopeEntity[] automationScopeEntities = existingRule.getAutomationScopeEntities();
        this.activeObjects.delete((RawEntity[])automationScopeEntities);
        this.activeObjects.delete(new RawEntity[]{existingRule});
        return Response.ok((Object)"{}").build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response editRule(@Context HttpServletRequest request, AutomationCreationJson automationJson, @QueryParam(value="index") int index) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        AutomationEntity existingRule = (AutomationEntity)this.activeObjects.get(AutomationEntity.class, (Object)index);
        existingRule.setName(automationJson.getName());
        AutomationExtractionEntity[] automationExtractionEntities = (AutomationExtractionEntity[])this.activeObjects.find(AutomationExtractionEntity.class, Query.select().where("AUTOMATION_ENTITY_ID = ?", new Object[]{index}));
        this.activeObjects.delete((RawEntity[])automationExtractionEntities);
        AutomationActionEntity[] automationActionEntities = existingRule.getAutomationActionEntities();
        this.activeObjects.delete((RawEntity[])automationActionEntities);
        AutomationScopeEntity[] automationScopeEntities = existingRule.getAutomationScopeEntities();
        this.activeObjects.delete((RawEntity[])automationScopeEntities);
        existingRule.setDetectionEnabled(automationJson.getDetectionEnabled());
        for (Integer extractionId : automationJson.getExtractions()) {
            if (this.activeObjects.get(ExtractionEntity.class, (Object)extractionId) == null) continue;
            this.activeObjects.create(AutomationExtractionEntity.class, new DBParam[]{new DBParam("AUTOMATION_ENTITY_ID", (Object)existingRule.getID()), new DBParam("EXTRACTION_ENTITY_ID", (Object)extractionId)});
        }
        for (String spaceKey : automationJson.getScope()) {
            if (this.spaceManager.getSpace(spaceKey) == null) continue;
            this.activeObjects.create(AutomationScopeEntity.class, new DBParam[]{new DBParam("AUTOMATION_ENTITY_ID", (Object)existingRule.getID()), new DBParam("SPACE_KEY", (Object)spaceKey)});
        }
        for (AutomationActionJson action : automationJson.getActions()) {
            switch (action.getType()) {
                case "label": {
                    this.activeObjects.create(AutomationActionEntity.class, new DBParam[]{new DBParam("AUTOMATION_ENTITY_ID", (Object)existingRule.getID()), new DBParam("TYPE", (Object)action.getType()), new DBParam("LABEL", (Object)action.getLabel())});
                    break;
                }
                case "email": {
                    this.activeObjects.create(AutomationActionEntity.class, new DBParam[]{new DBParam("AUTOMATION_ENTITY_ID", (Object)existingRule.getID()), new DBParam("TYPE", (Object)action.getType()), new DBParam("USER", (Object)action.getUsers())});
                    break;
                }
                case "classify": {
                    this.activeObjects.create(AutomationActionEntity.class, new DBParam[]{new DBParam("AUTOMATION_ENTITY_ID", (Object)existingRule.getID()), new DBParam("TYPE", (Object)action.getType()), new DBParam("LEVEL", (Object)action.getLevel())});
                    break;
                }
                case "redact": {
                    this.activeObjects.create(AutomationActionEntity.class, new DBParam[]{new DBParam("AUTOMATION_ENTITY_ID", (Object)existingRule.getID()), new DBParam("TYPE", (Object)action.getType())});
                    break;
                }
            }
        }
        AutomationJson automationJson1 = AutomationJson.map(existingRule, this.spaceManager);
        existingRule.save();
        return Response.ok((Object)automationJson1).build();
    }

    @POST
    @Path(value="/adhoc")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doAdHocAction(@Context HttpServletRequest request, AdHocChangeRequestJson changeRequestJson) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        switch (changeRequestJson.getAction()) {
            case "redact": {
                if (changeRequestJson.getSelectedItems().isEmpty()) {
                    this.automationService.redactAllItems(false, user, changeRequestJson);
                    break;
                }
                this.automationService.redactSelectedItems(false, user, changeRequestJson.getSelectedItems());
                break;
            }
            case "whitelist": {
                if (!changeRequestJson.getSelectedItems().isEmpty()) break;
                break;
            }
            case "classify": {
                if (!changeRequestJson.getSelectedItems().isEmpty()) break;
                break;
            }
            default: {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        return Response.ok().build();
    }
}

