/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.entity.analysis.ExtractionResult;
import co.uk.automationconsultants.compliance.exception.task.InvalidParamsException;
import co.uk.automationconsultants.compliance.exception.task.InvalidTaskTypeException;
import co.uk.automationconsultants.compliance.json.analysis.AnalysisResultJson;
import co.uk.automationconsultants.compliance.json.task.TaskCreationJson;
import co.uk.automationconsultants.compliance.json.task.TaskTypeEnum;
import co.uk.automationconsultants.compliance.json.task.params.SensitiveDataScanParams;
import co.uk.automationconsultants.compliance.service.AnalysisService;
import co.uk.automationconsultants.compliance.task.TaskManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@Path(value="/analysis")
public class AnalysisRest {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final AnalysisService analysisService;
    private final TaskManager taskManager;

    @Inject
    public AnalysisRest(ActiveObjects activeObjects, SpaceManager spaceManager, PageManager pageManager, PermissionManager permissionManager, UserManager userManager, UserAccessor userAccessor, AnalysisService analysisService, TaskManager taskManager) {
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.analysisService = analysisService;
        this.taskManager = taskManager;
    }

    @GET
    @Path(value="/page")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getResultsForPage(@Context HttpServletRequest request, @QueryParam(value="pid") long pid, @QueryParam(value="all") @DefaultValue(value="false") boolean all) {
        boolean allResults;
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        Page page = this.pageManager.getPage(pid);
        if (page == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)page)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        int version = page.getVersion();
        long pageId = page.getLatestVersion().getId();
        boolean bl = allResults = version != page.getLatestVersion().getVersion();
        if (allResults) {
            return Response.ok(AnalysisResultJson.mapAll(this.spaceManager, this.pageManager, (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "PAGE_ID = ? AND PAGE_VERSION = ?", new Object[]{pageId, version}))).build();
        }
        return Response.ok(AnalysisResultJson.mapAll(this.spaceManager, this.pageManager, (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "PAGE_ID = ? AND PAGE_VERSION = ? AND ACTIVE = ?", new Object[]{pageId, version, true}))).build();
    }

    @POST
    @Path(value="/maintenance")
    public Response runMaintenanceScan(@Context HttpServletRequest request) throws InvalidParamsException, InvalidTaskTypeException {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (user == null || !this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.analysisService.processMaintenanceScan();
        SensitiveDataScanParams params = new SensitiveDataScanParams(true);
        TaskCreationJson taskCreationJson = new TaskCreationJson(TaskTypeEnum.SENSITIVE_DATA_SCAN.name(), new Gson().toJson((Object)params));
        this.taskManager.addTask(taskCreationJson, user.getKey().getStringValue());
        return Response.ok().build();
    }
}

