/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.json.task;

import co.uk.automationconsultants.compliance.entity.task.TaskLog;
import co.uk.automationconsultants.compliance.json.analysis.PageJson;
import co.uk.automationconsultants.compliance.json.analysis.SpaceJson;
import co.uk.automationconsultants.compliance.json.task.LogLevelEnum;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TaskLogJson {
    @XmlElement(name="timeCreated")
    private Date timeCreated;
    @XmlElement(name="message")
    private String message;
    @XmlElement(name="logLevel")
    private LogLevelEnum logLevel;
    @XmlElement(name="pageId")
    private Long pageId;
    @XmlElement(name="spaceId")
    private Long spaceId;
    @XmlElement(name="spaceKey")
    private String spaceKey;
    @XmlElement(name="page")
    private PageJson page;
    @XmlElement(name="space")
    private SpaceJson space;

    public TaskLogJson() {
    }

    public TaskLogJson(Date timeCreated, String message, LogLevelEnum logLevel, Long pageId, Long spaceId, String spaceKey) {
        this.timeCreated = timeCreated;
        this.message = message;
        this.logLevel = logLevel;
        this.pageId = pageId;
        this.spaceId = spaceId;
        this.spaceKey = spaceKey;
    }

    public TaskLogJson(Date timeCreated, String message, LogLevelEnum logLevel, Long pageId, Long spaceId, String spaceKey, PageJson page, SpaceJson space) {
        this.timeCreated = timeCreated;
        this.message = message;
        this.logLevel = logLevel;
        this.page = page;
        this.space = space;
        this.pageId = pageId;
        this.spaceId = spaceId;
        this.spaceKey = spaceKey;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getMessage() {
        return this.message;
    }

    public LogLevelEnum getLogLevel() {
        return this.logLevel;
    }

    public PageJson getPage() {
        return this.page;
    }

    public SpaceJson getSpace() {
        return this.space;
    }

    public Long getPageId() {
        return this.pageId;
    }

    public Long getSpaceId() {
        return this.spaceId;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public static TaskLogJson toTaskLogJson(TaskLog taskLog) {
        if (taskLog == null) {
            return null;
        }
        return new TaskLogJson(taskLog.getTimeCreated(), taskLog.getMessage(), LogLevelEnum.toLogLevelEnum(taskLog.getLogLevel()), taskLog.getPageId(), taskLog.getSpaceId(), taskLog.getSpaceKey());
    }

    public static TaskLogJson[] toTaskLogJsons(TaskLog[] taskLogs) {
        return (TaskLogJson[])Arrays.stream(taskLogs).map(TaskLogJson::toTaskLogJson).toArray(TaskLogJson[]::new);
    }

    private static Map<Long, PageJson> buildPageMap(List<String> pageIds, CQLSearchService cqlSearchService) {
        if (pageIds.isEmpty()) {
            return new HashMap<Long, PageJson>();
        }
        HashMap<Long, PageJson> pageMap = new HashMap<Long, PageJson>();
        boolean more = true;
        int start = 0;
        int limit = 25;
        while (more) {
            PageResponse response = cqlSearchService.searchContent(String.format("id in (%s)", String.join((CharSequence)",", pageIds)), (PageRequest)new SimplePageRequest(start, 25), new Expansion[]{new Expansion("version")});
            response.getResults().forEach(content -> {
                PageJson pageJson = new PageJson(content.getId().asLong(), content.getTitle(), content.getVersion().getNumber());
                pageMap.put(content.getId().asLong(), pageJson);
            });
            more = response.hasMore();
            start += 25;
        }
        return pageMap;
    }

    private static Map<Long, SpaceJson> buildSpaceMap(String[] spaceKeys, SpaceService spaceService) {
        if (spaceKeys.length == 0) {
            return new HashMap<Long, SpaceJson>();
        }
        HashMap<Long, SpaceJson> spaceMap = new HashMap<Long, SpaceJson>();
        int start = 0;
        int limit = 25;
        boolean more = true;
        while (more) {
            SpaceService.SpaceFinder spaceFinder = spaceService.find(new Expansion[]{new Expansion("icon")}).withKeys(spaceKeys);
            PageResponse spaceResponse = spaceFinder.fetchMany((PageRequest)new SimplePageRequest(start, limit));
            spaceResponse.getResults().forEach(space -> spaceMap.put(space.getId(), new SpaceJson(space.getId(), space.getKey(), space.getName(), ((Icon)space.getIconRef().get()).getPath())));
            start += limit;
            more = spaceResponse.hasMore();
        }
        return spaceMap;
    }

    public static TaskLogJson[] toTaskLogJsons(TaskLog[] taskLogs, CQLSearchService cqlSearchService, SpaceService spaceService) {
        List<String> pageIds = Arrays.stream(taskLogs).map(TaskLog::getPageId).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        Map<Long, PageJson> pageMap = TaskLogJson.buildPageMap(pageIds, cqlSearchService);
        String[] spaceKeys = (String[])Arrays.stream(taskLogs).map(TaskLog::getSpaceKey).filter(Objects::nonNull).toArray(String[]::new);
        Map<Long, SpaceJson> spaceMap = TaskLogJson.buildSpaceMap(spaceKeys, spaceService);
        return (TaskLogJson[])Arrays.stream(taskLogs).map(taskLog -> new TaskLogJson(taskLog.getTimeCreated(), taskLog.getMessage(), LogLevelEnum.toLogLevelEnum(taskLog.getLogLevel()), taskLog.getPageId(), taskLog.getSpaceId(), taskLog.getSpaceKey(), (PageJson)pageMap.get(taskLog.getPageId()), (SpaceJson)spaceMap.get(taskLog.getSpaceId()))).toArray(TaskLogJson[]::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskLogJson that = (TaskLogJson)o;
        return this.timeCreated.equals(that.timeCreated) && this.message.equals(that.message) && this.logLevel == that.logLevel && Objects.equals(this.pageId, that.pageId) && Objects.equals(this.spaceId, that.spaceId) && Objects.equals(this.spaceKey, that.spaceKey) && Objects.equals(this.page, that.page) && Objects.equals(this.space, that.space);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timeCreated, this.message, this.logLevel, this.pageId, this.spaceId, this.spaceKey, this.page, this.space});
    }
}

