/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.json.task;

import co.uk.automationconsultants.compliance.entity.task.Task;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.json.task.TaskTypeEnum;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TaskJson {
    @XmlElement(name="id")
    private int id;
    @XmlElement(name="timeCreated")
    private Date timeCreated;
    @XmlElement(name="timeStarted")
    private Date timeStarted;
    @XmlElement(name="timeEnded")
    private Date timeEnded;
    @XmlElement(name="progress")
    private double progress;
    @XmlElement(name="paramsJson")
    private String paramsJson;
    @XmlElement(name="status")
    private TaskStatusEnum status;
    @XmlElement(name="taskType")
    private TaskTypeEnum taskType;
    @XmlElement(name="creator")
    private String creator;
    @XmlElement(name="success")
    private int success;
    @XmlElement(name="failed")
    private int failed;
    @XmlElement(name="skipped")
    private int skipped;
    @XmlElement(name="warning")
    private int warning;
    @XmlElement(name="totalCount")
    private int totalCount;
    @XmlElement(name="exclusiveExecution")
    private boolean exclusiveExecution;
    @XmlElement(name="managerNode")
    private String managerNode;
    @XmlElement(name="electedNode")
    private String electedNode;
    @XmlElement(name="lastStatusChange")
    private Date lastStatusChange;

    public TaskJson(int id, Date timeCreated, Date timeStarted, Date timeEnded, String paramsJson, TaskStatusEnum status, TaskTypeEnum taskType, String creator, int success, int failed, int skipped, int warning, int totalCount, boolean exclusiveExecution, String managerNode, String electedNode, Date lastStatusChange) {
        this.id = id;
        this.timeCreated = timeCreated;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.paramsJson = paramsJson;
        this.status = status;
        this.taskType = taskType;
        this.creator = creator;
        this.success = success;
        this.failed = failed;
        this.skipped = skipped;
        this.warning = warning;
        this.totalCount = totalCount;
        this.exclusiveExecution = exclusiveExecution;
        this.managerNode = managerNode;
        this.electedNode = electedNode;
        this.lastStatusChange = lastStatusChange;
    }

    public TaskJson() {
    }

    public int getId() {
        return this.id;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public double getProgress() {
        return this.progress;
    }

    public String getParamsJson() {
        return this.paramsJson;
    }

    public TaskStatusEnum getStatus() {
        return this.status;
    }

    public TaskTypeEnum getTaskType() {
        return this.taskType;
    }

    public String getCreator() {
        return this.creator;
    }

    public int getSuccess() {
        return this.success;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public int getWarning() {
        return this.warning;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public String getElectedNode() {
        return this.electedNode;
    }

    public String getManagerNode() {
        return this.managerNode;
    }

    public boolean isExclusiveExecution() {
        return this.exclusiveExecution;
    }

    public Date getLastStatusChange() {
        return this.lastStatusChange;
    }

    public boolean isRunning() {
        return this.status.equals((Object)TaskStatusEnum.IN_PROGRESS);
    }

    public boolean isManagedByNode(String nodeId) {
        return this.managerNode.equals(nodeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskJson taskJson = (TaskJson)o;
        return this.id == taskJson.id && Double.compare(taskJson.progress, this.progress) == 0 && this.success == taskJson.success && this.failed == taskJson.failed && this.skipped == taskJson.skipped && this.warning == taskJson.warning && this.totalCount == taskJson.totalCount && this.exclusiveExecution == taskJson.exclusiveExecution && Objects.equals(this.timeCreated, taskJson.timeCreated) && Objects.equals(this.timeStarted, taskJson.timeStarted) && Objects.equals(this.timeEnded, taskJson.timeEnded) && Objects.equals(this.paramsJson, taskJson.paramsJson) && Objects.equals((Object)this.status, (Object)taskJson.getStatus()) && Objects.equals((Object)this.taskType, (Object)taskJson.getTaskType()) && Objects.equals(this.creator, taskJson.getCreator()) && Objects.equals(this.managerNode, taskJson.managerNode) && Objects.equals(this.electedNode, taskJson.electedNode) && Objects.equals(this.lastStatusChange, taskJson.getLastStatusChange());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.timeCreated, this.timeStarted, this.timeEnded, this.progress, this.paramsJson, this.status, this.taskType, this.creator, this.success, this.failed, this.skipped, this.warning, this.totalCount, this.exclusiveExecution, this.managerNode, this.electedNode, this.lastStatusChange});
    }

    public static TaskJson toTaskJson(Task task) {
        if (task == null) {
            return null;
        }
        return new TaskJson(task.getID(), task.getTimeCreated(), task.getTimeStarted(), task.getTimeEnded(), task.getParamsJson(), TaskStatusEnum.toTaskStatusEnum(task.getTaskStatus()), TaskTypeEnum.toTaskTypeEnum(task.getTaskType()), task.getCreator(), task.getSuccess(), task.getFailed(), task.getSkipped(), task.getWarning(), task.getTotalCount(), task.getExclusiveExecution(), task.getManagerNode(), task.getElectedNode(), task.getLastStatusChange());
    }

    public static TaskJsonPayloadBuilder builder() {
        return new TaskJsonPayloadBuilder();
    }

    public static List<TaskJson> toTaskJsonList(Task[] tasks) {
        return Arrays.stream(tasks).map(TaskJson::toTaskJson).collect(Collectors.toList());
    }

    public static class TaskJsonPayloadBuilder {
        private int id;
        private Date timeStarted;
        private Date timeEnded;
        private TaskStatusEnum status;
        private int success;
        private int failed;
        private int skipped;
        private int warning;
        private int totalCount;
        private String electedNode;
        private String managerNode;

        public TaskJson build() {
            return new TaskJson(this.id, null, this.timeStarted, this.timeEnded, null, this.status, null, null, this.success, this.failed, this.skipped, this.warning, this.totalCount, false, this.managerNode, this.electedNode, null);
        }

        public TaskJsonPayloadBuilder id(int id) {
            this.id = id;
            return this;
        }

        public TaskJsonPayloadBuilder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            return this;
        }

        public TaskJsonPayloadBuilder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            return this;
        }

        public TaskJsonPayloadBuilder status(TaskStatusEnum status) {
            this.status = status;
            return this;
        }

        public TaskJsonPayloadBuilder success(int success) {
            this.success = success;
            return this;
        }

        public TaskJsonPayloadBuilder failed(int failed) {
            this.failed = failed;
            return this;
        }

        public TaskJsonPayloadBuilder skipped(int skipped) {
            this.skipped = skipped;
            return this;
        }

        public TaskJsonPayloadBuilder warning(int warning) {
            this.warning = warning;
            return this;
        }

        public TaskJsonPayloadBuilder totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public TaskJsonPayloadBuilder electedNode(String electedNode) {
            this.electedNode = electedNode;
            return this;
        }

        public TaskJsonPayloadBuilder managerNode(String managerNode) {
            this.managerNode = managerNode;
            return this;
        }
    }
}

