/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.json.analysis;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SpaceJson {
    @XmlElement(name="id")
    public Long id;
    @XmlElement(name="key")
    public String key;
    @XmlElement(name="name")
    public String name;
    @XmlElement(name="icon")
    public String icon;

    public static SpaceJson map(SpaceManager spaceManager, Long spaceId) {
        if (spaceId == null) {
            return null;
        }
        Space space = spaceManager.getSpace(spaceId.longValue());
        if (space == null) {
            return null;
        }
        return new SpaceJson(space.getId(), space.getKey(), space.getName(), spaceManager.getLogoForSpace(space.getKey()).getDownloadPath());
    }

    public SpaceJson() {
    }

    public SpaceJson(Long id, String key, String name, String icon) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.icon = icon;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpaceJson spaceJson = (SpaceJson)o;
        return this.id.equals(spaceJson.id) && this.key.equals(spaceJson.key) && this.name.equals(spaceJson.name) && Objects.equals(this.icon, spaceJson.icon);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "SpaceJson{id=" + this.id + ", key='" + this.key + "', name='" + this.name + "', icon='" + this.icon + "'}";
    }
}

