/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.json.analysis;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PageJson {
    @XmlElement(name="id")
    public Long id;
    @XmlElement(name="title")
    public String title;
    @XmlElement(name="version")
    public Integer version;

    public PageJson() {
    }

    public PageJson(Long id, String title, Integer version) {
        this.id = id;
        this.title = title;
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public static PageJson map(PageManager pageManager, Long pageId, Integer pageVersion) {
        if (pageId == null) {
            return null;
        }
        Page page = pageManager.getPage(pageId.longValue());
        if (page == null) {
            return null;
        }
        return new PageJson(page.getId(), page.getDisplayTitle(), pageVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageJson pageJson = (PageJson)o;
        return this.id.equals(pageJson.id) && this.title.equals(pageJson.title) && this.version.equals(pageJson.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.version);
    }

    public String toString() {
        return "PageJson{id=" + this.id + ", title='" + this.title + "', version=" + this.version + "}";
    }
}

