/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.json.action;

import co.uk.automationconsultants.compliance.entity.automation.AutomationEntity;
import co.uk.automationconsultants.compliance.json.action.AutomationActionJson;
import co.uk.automationconsultants.compliance.json.action.AutomationScopeJson;
import co.uk.automationconsultants.compliance.json.capture.ExtractionJson;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AutomationJson {
    @XmlElement(name="id")
    private Integer id;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="enabled")
    private Boolean enabled;
    @XmlElement(name="executions")
    private Integer executions;
    @XmlElement(name="createdOn")
    private Date createdOn;
    @XmlElement(name="extractions")
    private List<ExtractionJson> extractions;
    @XmlElement(name="detectionEnabled")
    private boolean detectionEnabled;
    @XmlElement(name="scope")
    private List<AutomationScopeJson> scope;
    @XmlElement(name="actions")
    private List<AutomationActionJson> actions;

    public static AutomationJson map(AutomationEntity automationEntity, SpaceManager spaceManager) {
        return new AutomationJson(automationEntity.getID(), automationEntity.getName(), automationEntity.isEnabled(), automationEntity.getExecutions(), automationEntity.getDetectionEnabled(), automationEntity.getCreatedOn(), Arrays.stream(automationEntity.getExtractionEntities()).map(extractionEntity -> new ExtractionJson(extractionEntity.getID(), extractionEntity.getName(), extractionEntity.getDescription(), extractionEntity.getIcon(), extractionEntity.getRegEx(), extractionEntity.isEnabled(), extractionEntity.isSysDefined())).collect(Collectors.toList()), Arrays.stream(automationEntity.getAutomationScopeEntities()).map(automationScopeEntity -> {
            Space space = spaceManager.getSpace(automationScopeEntity.getSpaceKey());
            if (space == null) {
                return null;
            }
            return new AutomationScopeJson(automationScopeEntity.getID(), space.getKey(), space.getName(), "");
        }).filter(Objects::nonNull).collect(Collectors.toList()), Arrays.stream(automationEntity.getAutomationActionEntities()).map(automationActionEntity -> new AutomationActionJson(automationActionEntity.getID(), automationActionEntity.getType(), automationActionEntity.getLevel(), automationActionEntity.getUser(), automationActionEntity.getLabel())).collect(Collectors.toList()));
    }

    public AutomationJson() {
    }

    public AutomationJson(Integer id, String name, Boolean enabled, Integer executions, boolean detectionEnabled, Date createdOn, List<ExtractionJson> extractions, List<AutomationScopeJson> scope, List<AutomationActionJson> actions) {
        this.id = id;
        this.name = name;
        this.enabled = enabled;
        this.executions = executions;
        this.detectionEnabled = detectionEnabled;
        this.createdOn = createdOn;
        this.extractions = extractions;
        this.scope = scope;
        this.actions = actions;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getExecutions() {
        return this.executions;
    }

    public void setExecutions(Integer executions) {
        this.executions = executions;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public List<ExtractionJson> getExtractions() {
        return this.extractions;
    }

    public void setExtractions(List<ExtractionJson> extractions) {
        this.extractions = extractions;
    }

    public boolean getDetectionEnabled() {
        return this.detectionEnabled;
    }

    public void setDetectionEnabled(boolean detectionEnabled) {
        this.detectionEnabled = detectionEnabled;
    }

    public List<AutomationScopeJson> getScope() {
        return this.scope;
    }

    public void setScope(List<AutomationScopeJson> scope) {
        this.scope = scope;
    }

    public List<AutomationActionJson> getActions() {
        return this.actions;
    }

    public void setActions(List<AutomationActionJson> actions) {
        this.actions = actions;
    }
}

