/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

@Named(value="onStartDBMod")
public class OnStartDBModComponent
implements ActiveObjectsUpgradeTask {
    @ComponentImport
    private final TransactionalExecutorFactory transactionalExecutorFactory;
    @ComponentImport
    private final SystemInformationService systemInformationService;

    @Inject
    public OnStartDBModComponent(SystemInformationService systemInformationService, TransactionalExecutorFactory transactionalExecutorFactory) {
        this.systemInformationService = systemInformationService;
        this.transactionalExecutorFactory = transactionalExecutorFactory;
    }

    private boolean hasSQLResult(Connection connection, String sql) throws SQLException {
        try (Statement statement = connection.createStatement();){
            boolean executedSuccess = statement.execute(connection.nativeSQL(sql));
            if (executedSuccess) {
                ResultSet resultSet = statement.getResultSet();
                boolean bl = resultSet.next();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private void changeSystemColumn() {
        this.transactionalExecutorFactory.create().execute(connection -> {
            try {
                this.changeSystemColumn(connection);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    private void changeSystemColumn(Connection connection) throws SQLException {
        String dialect = this.systemInformationService.getDatabaseInfo().getDialect();
        this.systemInformationService.getDatabaseInfo().getUrl();
        if (dialect.contains("PostgreSQL")) {
            String checkForColumnSQL = "SELECT column_name FROM information_schema.columns WHERE table_name='AO_E5C20A_EXTRACTIONS' and column_name='SYSTEM';";
            String modColumnSQL = "ALTER TABLE \"AO_E5C20A_EXTRACTIONS\" RENAME COLUMN \"SYSTEM\" TO \"SYS_DEFINED\";";
            boolean columnNeedsRenaming = this.hasSQLResult(connection, checkForColumnSQL);
            if (columnNeedsRenaming) {
                this.hasSQLResult(connection, modColumnSQL);
            }
        } else if (dialect.contains("H2")) {
            String checkForColumnSQL = "SELECT column_name FROM information_schema.columns WHERE table_name='AO_E5C20A_EXTRACTIONS' and column_name='SYSTEM';";
            String modColumnSQL = "ALTER TABLE \"AO_E5C20A_EXTRACTIONS\" RENAME COLUMN \"SYSTEM\" TO \"SYS_DEFINED\";";
            boolean columnNeedsRenaming = this.hasSQLResult(connection, checkForColumnSQL);
            if (columnNeedsRenaming) {
                this.hasSQLResult(connection, modColumnSQL);
            }
        } else if (dialect.contains("Oracle")) {
            String checkForColumnSQL = "select column_name as found from user_tab_cols where table_name = 'AO_E5C20A_EXTRACTIONS' and column_name = 'SYSTEM'";
            String modColumnSQL = "alter table AO_E5C20A_EXTRACTIONS rename column SYSTEM TO SYS_DEFINED;";
            boolean columnNeedsRenaming = this.hasSQLResult(connection, checkForColumnSQL);
            if (columnNeedsRenaming) {
                this.hasSQLResult(connection, modColumnSQL);
            }
        } else if (dialect.contains("SQLServer")) {
            String checkForColumnSQL = "IF EXISTS(SELECT * FROM sys.columns WHERE Name = N'SYSTEM' AND OBJECT_ID = OBJECT_ID(N'AO_E5C20A_EXTRACTIONS'))\n        BEGIN\n        EXEC sp_rename 'AO_E5C20A_EXTRACTIONS.SYSTEM', 'SYS_DEFINED', 'COLUMN';\n        END";
            this.hasSQLResult(connection, checkForColumnSQL);
        } else if (dialect.contains("MySQL")) {
            String checkForColumnSQL = "SELECT * FROM information_schema.COLUMNS WHERE TABLE_NAME = 'AO_E5C20A_EXTRACTIONS' AND COLUMN_NAME = 'SYSTEM'";
            String modColumnSQL = "ALTER TABLE `AO_E5C20A_EXTRACTIONS` CHANGE COLUMN `SYSTEM` `SYS_DEFINED` BOOLEAN NOT NULL;";
            boolean columnNeedsRenaming = this.hasSQLResult(connection, checkForColumnSQL);
            if (columnNeedsRenaming) {
                this.hasSQLResult(connection, modColumnSQL);
            }
        }
    }

    public ModelVersion getModelVersion() {
        this.changeSystemColumn();
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
    }
}

