/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.entity.PluginUpgradeTask;

import co.uk.automationconsultants.compliance.entity.SettingEntity;
import co.uk.automationconsultants.compliance.service.AnalysisService;
import co.uk.automationconsultants.compliance.utils.PluginUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.user.GroupManager;
import jakarta.annotation.Nonnull;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
@ExportAsService(value={PluginUpgradeTask.class})
public class AnalysisOsnoeUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(AnalysisOsnoeUpgradeTask.class);
    @ComponentImport
    private final ActiveObjects activeObjects;
    private final CQLSearchService cqlSearchService;
    private final PageManager pageManager;
    private final AnalysisService analysisService;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private static final int RESULTS_LIMIT = 500;

    public AnalysisOsnoeUpgradeTask(ActiveObjects activeObjects, CQLSearchService cqlSearchService, PageManager pageManager, AnalysisService analysisService, GroupManager groupManager, UserAccessor userAccessor) {
        this.activeObjects = activeObjects;
        this.cqlSearchService = cqlSearchService;
        this.pageManager = pageManager;
        this.analysisService = analysisService;
        this.groupManager = groupManager;
        this.userAccessor = userAccessor;
    }

    public int getBuildNumber() {
        log.debug("Getting build number for upgrade task, returning {}", (Object)1);
        return 1;
    }

    @Nonnull
    public String getShortDescription() {
        return "Updates pages which have been modified since the last scan with [contentanalysis].constant = 0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Message> doUpgrade() throws Exception {
        log.info("Running AnalysisOsnoeUpgradeTask");
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
            log.debug("Fetching Compliance scan settings");
            if (!this.shouldRunTask(settings)) {
                Set<Message> set = Collections.emptySet();
                return set;
            }
            String actingUser = settings[0].getActingUser();
            Date lastScanDate = settings[0].getLastScheduledScan();
            ConfluenceUser admin = this.userAccessor.getUserByName(actingUser);
            log.debug("Setting acting user to " + actingUser + " for upgrade task");
            AuthenticatedUserThreadLocal.set((ConfluenceUser)admin);
            String lastScanString = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(lastScanDate);
            log.debug("Starting upgrade task to update pages modified since " + lastScanString + " with content.property[contentanalysis].constant = 0");
            String cql = String.format("type = page AND content.property[classificationanalysis].constant = 1 AND lastmodified >= \"%s\"", lastScanString);
            int totalResults = this.cqlSearchService.countContent(cql);
            int startAt = Math.max(totalResults - 500, 0);
            int totalProcessed = 0;
            int batchNumber = 1;
            while (true) {
                PageResponse results = this.cqlSearchService.searchContent(cql, (PageRequest)new SimplePageRequest(startAt, 500), new Expansion[0]);
                ArrayList<Future> futures = new ArrayList<Future>();
                for (Content result : results.getResults()) {
                    Future future = executor.submit(() -> this.processPage(result.getId().asLong(), admin, 0));
                    futures.add(future);
                }
                AtomicInteger processedPages = new AtomicInteger(0);
                for (Future future : futures) {
                    int processed = (Integer)future.get();
                    processedPages.addAndGet(processed);
                }
                log.debug("Batch {}: Processed {} pages in batch", (Object)batchNumber, (Object)processedPages.get());
                log.debug("Batch {}: Processed {} pages in total", (Object)batchNumber, (Object)(totalProcessed += processedPages.get()));
                if (startAt <= 0) {
                    break;
                }
                startAt = Math.max(startAt - 500, 0);
                ++batchNumber;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Error occurred during upgrade task", (Throwable)e);
        }
        finally {
            log.debug("Finished OSNOE upgrade task. Shutting down executor");
            executor.shutdown();
            try {
                if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException ie) {
                executor.shutdownNow();
            }
        }
        return Collections.emptySet();
    }

    public int processPage(Long pageId, ConfluenceUser actingUser, int constant) {
        try {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)actingUser);
            Page page = this.pageManager.getPage(pageId.longValue());
            if (page != null) {
                this.analysisService.createOrUpdateAnalysisProperty((AbstractPage)page, constant);
            }
            return 1;
        }
        catch (Exception e) {
            log.error("Error occurred migrating a page", (Throwable)e);
            return 0;
        }
    }

    public boolean shouldRunTask(SettingEntity[] settings) {
        if (settings.length == 0) {
            log.debug("No Compliance scan settings found, stopping upgrade task.");
            return false;
        }
        String actingUser = settings[0].getActingUser();
        if (actingUser == null) {
            log.debug("No acting user found in Compliance scan settings, stopping upgrade task.");
            return false;
        }
        Date lastScanDate = settings[0].getLastScheduledScan();
        if (lastScanDate == null) {
            log.debug("No last scheduled scan date found in Compliance scan settings, stopping upgrade task.");
            return false;
        }
        return true;
    }

    @Nonnull
    public String getPluginKey() {
        return PluginUtils.getPluginPropertiesPluginKey();
    }
}

