/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.condition;

import co.uk.automationconsultants.compliance.cache.GlobalSettingsCache;
import co.uk.automationconsultants.compliance.cache.SpaceSettingsCache;
import co.uk.automationconsultants.compliance.json.level.LevelsJson;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import jakarta.inject.Inject;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveDataBylineCondition
implements Condition {
    private final GlobalSettingsCache globalSettingsCache;
    private static final Logger log = LoggerFactory.getLogger(SensitiveDataBylineCondition.class);
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final SpaceSettingsCache spaceSettingsCache;

    @Inject
    public SensitiveDataBylineCondition(GlobalSettingsCache globalSettingsCache, SpacePermissionManager spacePermissionManager, PermissionManager permissionManager, SpaceSettingsCache spaceSettingsCache) {
        this.globalSettingsCache = globalSettingsCache;
        this.spacePermissionManager = spacePermissionManager;
        this.permissionManager = permissionManager;
        this.spaceSettingsCache = spaceSettingsCache;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Space space = (Space)context.get("space");
        if (space == null) {
            return false;
        }
        LevelsJson globalSettings = this.globalSettingsCache.getGlobalSettings();
        try {
            if (!this.spaceSettingsCache.get(space.getKey()).isEnabled()) {
                return false;
            }
            ConfluenceUser user = (ConfluenceUser)context.get("user");
            return globalSettings.getDataByline() != false && this.spacePermissionManager.hasPermission("VIEWSPACE", space, user) || this.permissionManager.isConfluenceAdministrator(user);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            return false;
        }
    }
}

