/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CSVUtils {
    private static File file = null;
    private static CSVPrinter printer = null;

    public static void createCSVFile(String filenamePrefix) throws IOException {
        if (filenamePrefix == null || filenamePrefix.isEmpty()) {
            throw new IOException("Invalid file name.");
        }
        file = File.createTempFile(filenamePrefix, ".csv");
        printer = new CSVPrinter((Appendable)new FileWriter(file), CSVFormat.DEFAULT);
    }

    public static void writeHeaders(ArrayList<String> headers) throws IOException {
        if (headers == null || headers.isEmpty()) {
            throw new IOException("Invalid headers");
        }
        printer.printRecord(headers);
        printer.flush();
    }

    public static void writeRow(ArrayList<Object> record) throws IOException {
        if (record == null || record.isEmpty()) {
            throw new IOException("Invalid row.");
        }
        printer.printRecord(record);
        printer.flush();
    }

    public static File getFile() throws IOException {
        if (printer != null) {
            printer.close();
        }
        return file;
    }
}

