/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task.delegation;

import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.json.task.search.TaskSearchFilterJson;
import co.uk.automationconsultants.compliance.search.SearchResponse;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.TaskScanner;
import co.uk.automationconsultants.compliance.task.delegation.TaskDelegationService;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDelegator
implements Runnable {
    private boolean readyToDelegate;
    private static final Logger log = LoggerFactory.getLogger(TaskDelegator.class);
    private final TaskDelegationService taskDelegationService;
    private final TaskDBService taskDBService;
    private boolean runningThread = true;
    private final TransactionTemplate transactionTemplate;
    private final ClusterNodeInformation clusterNodeInformation;
    private final ClusterLockService clusterLockService;
    private final TaskScanner taskScanner;
    private static final String TASK_DELEGATOR_CLUSTER_LOCK = "TASK_DELEGATOR_CLUSTER_LOCK_";
    private final Thread thread;

    public TaskDelegator(TaskDelegationService taskDelegationService, TaskDBService taskDBService, TransactionTemplate transactionTemplate, ClusterNodeInformation clusterNodeInformation, ClusterLockService clusterLockService, TaskScanner taskScanner) {
        this.taskDelegationService = taskDelegationService;
        this.taskDBService = taskDBService;
        this.transactionTemplate = transactionTemplate;
        this.clusterNodeInformation = clusterNodeInformation;
        this.clusterLockService = clusterLockService;
        this.taskScanner = taskScanner;
        this.thread = new Thread(this);
    }

    public void killThread() {
        this.readyToDelegate = false;
        this.runningThread = false;
    }

    public synchronized void alertDelegator() {
        log.debug("Alerted delegator");
        this.readyToDelegate = true;
        this.notifyAll();
    }

    public void startThread() {
        this.thread.start();
        if (!this.thread.isAlive()) {
            log.error("Task Delegation Thread failed to start");
        }
    }

    @Override
    public synchronized void run() {
        while (this.runningThread) {
            while (!this.readyToDelegate) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("Task Delegation Thread was interrupted");
                }
            }
            try {
                SearchResponse<TaskJson> searchResponse;
                String cursor = null;
                do {
                    if ((searchResponse = this.getAssignedTasks(cursor, 50)).getResults().isEmpty()) {
                        this.wait(5000L);
                    }
                    searchResponse.getResults().forEach(this::processTask);
                } while ((cursor = searchResponse.getNext()) != null);
                this.wait(150L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Task Delegation Thread was interrupted");
                this.killThread();
            }
        }
    }

    private void processTask(TaskJson taskJson) {
        this.transactionTemplate.execute(() -> {
            ClusterLock lock = this.clusterLockService.getLockForName(TASK_DELEGATOR_CLUSTER_LOCK + taskJson.getId());
            log.debug("Delegating Task {}", (Object)taskJson.getId());
            if (!lock.tryLock()) {
                log.error("Another node is trying to delegate this task");
            } else {
                try {
                    this.taskDelegationService.delegateTask(taskJson.getId(), this.taskScanner);
                }
                catch (Exception e) {
                    log.error("An error occurred while delegating the task {}", (Object)e.getMessage());
                }
                finally {
                    lock.unlock();
                }
            }
            return null;
        });
    }

    private SearchResponse<TaskJson> getAssignedTasks(String cursor, int limit) {
        String managerNode = this.clusterNodeInformation == null ? "NO_CLUSTER" : this.clusterNodeInformation.getAnonymizedNodeIdentifier();
        return (SearchResponse)this.transactionTemplate.execute(() -> this.taskDBService.searchTasks(limit, cursor, TaskSearchFilterJson.builder().managerNode(managerNode).status(TaskStatusEnum.PENDING).build(), true));
    }
}

