/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.entity.scope.ScopeEntity;
import co.uk.automationconsultants.compliance.entity.scope.ScopeSpaceEntity;
import co.uk.automationconsultants.compliance.json.scope.ScopeJson;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.java.ao.DBParam;
import net.java.ao.Query;

@Path(value="/scope")
public class ScopeRest {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;

    @Inject
    public ScopeRest(ActiveObjects activeObjects, SpaceManager spaceManager, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager) {
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getScope(@Context HttpServletRequest request, @QueryParam(value="limit") Integer limit) {
        ScopeSpaceEntity[] spaceEntities;
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ScopeEntity[] scopeEntity = (ScopeEntity[])this.activeObjects.find(ScopeEntity.class, Query.select().order("ID DESC").limit(1));
        if (scopeEntity.length == 0) {
            this.activeObjects.create(ScopeEntity.class, new DBParam[]{new DBParam("SCOPE", (Object)"disabled")});
            return Response.ok((Object)new ScopeJson("disabled", new ArrayList<String>(), 0)).build();
        }
        ArrayList<String> spaces = new ArrayList<String>();
        if (limit == null) {
            this.activeObjects.stream(ScopeSpaceEntity.class, s -> spaces.add(s.getSpaceKey()));
            int size = spaces.size();
            spaces.removeIf(sk -> this.spaceManager.getSpace(sk) == null);
            return Response.ok((Object)new ScopeJson(scopeEntity[0].getScope(), spaces, size)).build();
        }
        int startAt = 0;
        do {
            spaceEntities = (ScopeSpaceEntity[])this.activeObjects.find(ScopeSpaceEntity.class, Query.select().offset(startAt).limit(limit.intValue()));
            spaces.addAll(Arrays.stream(spaceEntities).map(ScopeSpaceEntity::getSpaceKey).filter(key -> this.spaceManager.getSpace(key) != null).collect(Collectors.toList()));
            startAt += limit.intValue();
        } while (spaces.size() < limit && spaceEntities.length == limit);
        int size = this.activeObjects.count(ScopeSpaceEntity.class);
        return Response.ok((Object)new ScopeJson(scopeEntity[0].getScope(), spaces, size)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateScope(@Context HttpServletRequest request, ScopeJson scopeJson) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (!Arrays.asList("disabled", "enabled", "spaces").contains(scopeJson.getScope().toLowerCase())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ScopeEntity[] scopeEntity = (ScopeEntity[])this.activeObjects.find(ScopeEntity.class, Query.select().order("ID DESC").limit(1));
        if (scopeEntity.length == 0) {
            this.activeObjects.executeInTransaction(() -> (ScopeEntity)this.activeObjects.create(ScopeEntity.class, new DBParam[]{new DBParam("SCOPE", (Object)scopeJson.getScope())}));
        } else {
            this.activeObjects.executeInTransaction(() -> {
                scopeEntity[0].setScope(scopeJson.getScope());
                scopeEntity[0].save();
                return true;
            });
        }
        LinkedHashSet<String> dBSpaces = new LinkedHashSet<String>(scopeJson.getSpaces());
        this.activeObjects.executeInTransaction(() -> {
            this.activeObjects.deleteWithSQL(ScopeSpaceEntity.class, null, new Object[0]);
            dBSpaces.forEach(s -> this.activeObjects.create(ScopeSpaceEntity.class, new DBParam[]{new DBParam("SPACE_KEY", s)}));
            return true;
        });
        return Response.ok().build();
    }
}

