/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.listener;

import co.uk.automationconsultants.compliance.json.settings.GlobalSettingsJson;
import co.uk.automationconsultants.compliance.json.settings.SpaceSettingsPropertyJson;
import co.uk.automationconsultants.compliance.service.ClassificationService;
import co.uk.automationconsultants.compliance.utils.JsonUtils;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.JsonSpaceProperty;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.SpacePropertyService;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named(value="spaceSettingsListener")
public class SpaceSettingsListener
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SpaceSettingsListener.class);
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final SpacePropertyService spacePropertyService;
    private final ClassificationService classificationService;

    @Inject
    public SpaceSettingsListener(EventPublisher eventPublisher, SpacePropertyService spacePropertyService, ClassificationService classificationService) {
        this.eventPublisher = eventPublisher;
        this.spacePropertyService = spacePropertyService;
        this.classificationService = classificationService;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void spaceCreated(SpaceCreateEvent event) {
        GlobalSettingsJson globalSettings = this.classificationService.getSettings();
        if (globalSettings.getClassificationEnabledForNewSpaces().booleanValue() || !globalSettings.getClassificationEnabled().booleanValue()) {
            return;
        }
        JsonSpaceProperty existingSettings = (JsonSpaceProperty)this.spacePropertyService.find(new Expansion[0]).withSpaceKey(event.getSpace().getKey()).withPropertyKey("dataclassification").fetchOrNull();
        if (existingSettings != null) {
            return;
        }
        SpaceSettingsPropertyJson spaceSettings = new SpaceSettingsPropertyJson(this.classificationService.getSettings().getClassificationEnabledForNewSpaces(), false, false, Collections.emptyList(), Collections.emptyList());
        try {
            JsonSpaceProperty jsonSpaceProperty = ((JsonSpaceProperty.SpacePropertyBuilder)((JsonSpaceProperty.SpacePropertyBuilder)((JsonSpaceProperty.SpacePropertyBuilder)JsonSpaceProperty.builder().space(Space.builder().key(event.getSpace().getKey()).build()).key("dataclassification")).value(new JsonString(JsonUtils.marshal(spaceSettings)))).version(Version.builder().number(1).build())).build();
            ValidationResult result = this.spacePropertyService.validator().validateCreate(jsonSpaceProperty);
            if (!result.isValid() || !result.isAuthorized()) {
                log.error("Failed to validate space settings for new space {}", (Object)event.getSpace().getKey());
                return;
            }
            this.spacePropertyService.create(jsonSpaceProperty);
        }
        catch (IOException e) {
            log.error("Failed to serialize space settings for new space {}: {}", (Object)event.getSpace().getKey(), (Object)e.getMessage());
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

