/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task.search;

import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.search.TaskSearchCursor;
import co.uk.automationconsultants.compliance.json.task.search.TaskSearchFilterJson;
import co.uk.automationconsultants.compliance.task.search.SearchHelper;
import co.uk.automationconsultants.compliance.utils.StringUtils;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.Query;

public class TaskSearchHelper
implements SearchHelper<TaskSearchCursor, TaskSearchFilterJson, TaskJson> {
    @Override
    public TaskSearchCursor parseCursor(String cursor) {
        try {
            String decodedCursor = new String(Base64.getDecoder().decode(cursor));
            String[] values = decodedCursor.split("_");
            boolean isNext = values[0].equals("next");
            long timeCreated = Long.parseLong(values[1]);
            return new TaskSearchCursor(isNext, timeCreated);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Query generateQuery(TaskSearchCursor searchCursor, TaskSearchFilterJson filter, int limit, boolean oldestFirst) {
        Query baseQuery = this.generateBaseQuery(searchCursor, filter, oldestFirst);
        return baseQuery.limit(limit + 1).order(TaskSearchHelper.generateOrderClause(searchCursor, oldestFirst));
    }

    @Override
    public Query generateCountQuery(TaskSearchFilterJson filter) {
        return this.generateBaseQuery(null, filter, false);
    }

    @Override
    public String generatePrevCursor(TaskSearchCursor searchCursor, List<TaskJson> results, boolean isMore) {
        if (searchCursor == null || !isMore && !searchCursor.isNext()) {
            return null;
        }
        long timeCreated = results.get(0).getTimeCreated().getTime();
        String cursor = "prev_" + timeCreated;
        return Base64.getEncoder().encodeToString(cursor.getBytes());
    }

    @Override
    public String generateNextCursor(TaskSearchCursor searchCursor, List<TaskJson> results, boolean isMore) {
        if (!isMore && (searchCursor == null || searchCursor.isNext())) {
            return null;
        }
        long timeCreated = results.get(results.size() - 1).getTimeCreated().getTime();
        String cursor = "next_" + timeCreated;
        return Base64.getEncoder().encodeToString(cursor.getBytes());
    }

    private Query generateBaseQuery(TaskSearchCursor searchCursor, TaskSearchFilterJson filter, boolean oldestFirst) {
        return Query.select().where(this.generateWhereClause(filter, searchCursor, oldestFirst), this.getWhereClauseParam(filter, searchCursor));
    }

    private Object[] getWhereClauseParam(TaskSearchFilterJson filter, TaskSearchCursor searchCursor) {
        boolean exclusiveExecutionPresent;
        boolean searchCursorPresent = searchCursor != null;
        boolean bl = exclusiveExecutionPresent = filter != null && filter.getExclusiveExecution() != null;
        if (!searchCursorPresent && !exclusiveExecutionPresent) {
            return new Object[0];
        }
        if (!searchCursorPresent) {
            return new Object[]{filter.getExclusiveExecution()};
        }
        if (!exclusiveExecutionPresent) {
            return new Object[]{new Date(searchCursor.getTimeCreated())};
        }
        return new Object[]{filter.getExclusiveExecution(), new Date(searchCursor.getTimeCreated())};
    }

    private String generateWhereClause(TaskSearchFilterJson filter, TaskSearchCursor searchCursor, boolean oldestFirst) {
        String whereClause;
        String filterClause = this.generateWhereClauseNoCursor(filter);
        String cursorClause = null;
        if (searchCursor != null) {
            cursorClause = oldestFirst ? (searchCursor.isNext() ? "TIME_CREATED > ?" : "TIME_CREATED < ?") : (searchCursor.isNext() ? "TIME_CREATED < ?" : "TIME_CREATED > ?");
        }
        return (whereClause = Stream.of(filterClause, cursorClause).filter(Objects::nonNull).collect(Collectors.joining(" AND "))).isEmpty() ? null : whereClause;
    }

    private static String generateOrderClause(TaskSearchCursor searchCursor, boolean oldestFirst) {
        if (!oldestFirst) {
            return searchCursor == null || searchCursor.isNext() ? "TIME_CREATED DESC" : "TIME_CREATED ASC";
        }
        return searchCursor == null || searchCursor.isNext() ? "TIME_CREATED ASC" : "TIME_CREATED DESC";
    }

    private String generateWhereClauseNoCursor(TaskSearchFilterJson filter) {
        String whereClause;
        String statusClause = null;
        String taskTypeClause = null;
        String creatorClause = null;
        String managerNodeClause = null;
        String electedNodeClause = null;
        String exclusiveExecutionClause = null;
        if (filter != null) {
            statusClause = filter.getStatuses().isEmpty() ? null : "TASK_STATUS IN " + StringUtils.generateCommaSepListWrappedInBrackets(filter.getStatuses());
            taskTypeClause = filter.getTaskTypes().isEmpty() ? null : "TASK_TYPE IN " + StringUtils.generateCommaSepListWrappedInBrackets(filter.getTaskTypes());
            creatorClause = filter.getUserIds().isEmpty() ? null : "CREATOR IN " + StringUtils.generateCommaSepListWrappedInBrackets(filter.getUserIds());
            managerNodeClause = filter.getManagerNodes().isEmpty() ? null : "MANAGER_NODE IN " + StringUtils.generateCommaSepListWrappedInBrackets(filter.getManagerNodes());
            electedNodeClause = filter.getElectedNodes().isEmpty() ? null : "ELECTED_NODE IN " + StringUtils.generateCommaSepListWrappedInBrackets(filter.getElectedNodes());
            exclusiveExecutionClause = filter.getExclusiveExecution() == null ? null : "EXCLUSIVE_EXECUTION = ?";
        }
        return (whereClause = Stream.of(statusClause, taskTypeClause, creatorClause, managerNodeClause, electedNodeClause, exclusiveExecutionClause).filter(Objects::nonNull).collect(Collectors.joining(" AND "))).isEmpty() ? null : whereClause;
    }
}

