/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.json.externalapi;

import com.atlassian.confluence.user.ConfluenceUser;
import java.util.Objects;

public class ExternalAPIRequest {
    private String pageId;
    private String pageName;
    private String pageUrl;
    private String content;
    private ExternalAPIUser creator;
    private ExternalAPIUser modifier;
    private int pageVersion;
    private boolean isPageLatestVersion;
    private Long lastModificationDate;

    public ExternalAPIRequest() {
    }

    public ExternalAPIRequest(String pageId, String pageName, String pageUrl, String content, ConfluenceUser creator, ConfluenceUser modifier, int pageVersion, boolean isPageLatestVersion, Long lastModificationDate) {
        this.pageId = pageId;
        this.pageName = pageName;
        this.pageUrl = pageUrl;
        this.content = content;
        this.creator = new ExternalAPIUser("", "");
        if (creator != null) {
            this.creator = new ExternalAPIUser(creator.getKey().getStringValue(), creator.getName());
        }
        this.modifier = new ExternalAPIUser("", "");
        if (modifier != null) {
            this.modifier = new ExternalAPIUser(modifier.getKey().getStringValue(), modifier.getName());
        }
        this.pageVersion = pageVersion;
        this.isPageLatestVersion = isPageLatestVersion;
        this.lastModificationDate = lastModificationDate;
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public String getContent() {
        return this.content;
    }

    public ExternalAPIUser getCreator() {
        return this.creator;
    }

    public ExternalAPIUser getModifier() {
        return this.modifier;
    }

    public int getPageVersion() {
        return this.pageVersion;
    }

    public boolean getIsPageLatestVersion() {
        return this.isPageLatestVersion;
    }

    public Long getlastModificationDate() {
        return this.lastModificationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalAPIRequest that = (ExternalAPIRequest)o;
        return Objects.equals(this.pageId, that.pageId) && Objects.equals(this.pageName, that.pageName) && Objects.equals(this.pageUrl, that.pageUrl) && Objects.equals(this.content, that.content) && Objects.equals(this.creator, that.creator) && Objects.equals(this.modifier, that.modifier) && this.pageVersion == that.pageVersion && this.isPageLatestVersion == that.isPageLatestVersion && Objects.equals(this.lastModificationDate, that.lastModificationDate);
    }

    public int hashCode() {
        return Objects.hash(this.pageId, this.pageName, this.pageUrl, this.content, this.creator, this.modifier, this.pageVersion, this.isPageLatestVersion, this.lastModificationDate);
    }

    private static class ExternalAPIUser {
        private String id;
        private String username;

        public ExternalAPIUser() {
        }

        ExternalAPIUser(String id, String username) {
            this.id = id;
            this.username = username;
        }

        public String getId() {
            return this.id;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExternalAPIUser that = (ExternalAPIUser)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.username, that.username);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.username);
        }
    }
}

