/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.json.externalapi;

import co.uk.automationconsultants.compliance.entity.externalapi.ExternalAPIConfig;
import co.uk.automationconsultants.compliance.json.externalapi.AuthHeader;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigReadOnly;
import java.util.Objects;

public class ExternalAPIConfigJson
extends ExternalAPIConfigReadOnly {
    private final String username;
    private final String token;

    public ExternalAPIConfigJson(boolean enabled, String url, AuthHeader authHeader, String username, String token) {
        super(enabled, url, authHeader);
        this.username = username;
        this.token = token;
    }

    public ExternalAPIConfigJson(ExternalAPIConfig externalAPIConfig) {
        super(externalAPIConfig.isEnabled(), externalAPIConfig.getUrl(), AuthHeader.valueOf(externalAPIConfig.getAuthHeader()));
        this.username = externalAPIConfig.getUsername();
        this.token = externalAPIConfig.getToken();
    }

    public String getUsername() {
        return this.username;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalAPIConfigJson that = (ExternalAPIConfigJson)o;
        return Objects.equals(this.username, that.username) && this.token.equals(that.token);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.username, this.token);
    }

    public ExternalAPIConfigReadOnly toReadOnly() {
        return new ExternalAPIConfigReadOnly(this.enabled, this.url, this.authHeader);
    }
}

