/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task.tasks;

import co.uk.automationconsultants.compliance.entity.extractions.ExtractionEntity;
import co.uk.automationconsultants.compliance.exception.task.TaskExecutionException;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigReadOnly;
import co.uk.automationconsultants.compliance.json.scope.ScopeBaseJson;
import co.uk.automationconsultants.compliance.json.scope.ScopeEnum;
import co.uk.automationconsultants.compliance.json.settings.ScanSettings;
import co.uk.automationconsultants.compliance.json.task.LogLevelEnum;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskTypeEnum;
import co.uk.automationconsultants.compliance.json.task.params.SensitiveDataScanParams;
import co.uk.automationconsultants.compliance.service.AnalysisService;
import co.uk.automationconsultants.compliance.service.ExtractionService;
import co.uk.automationconsultants.compliance.service.ScopeService;
import co.uk.automationconsultants.compliance.service.externalapi.ExternalAPIService;
import co.uk.automationconsultants.compliance.service.settings.SettingsService;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.TaskRunnable;
import co.uk.automationconsultants.compliance.utils.StringUtils;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveDataScanTask
extends TaskRunnable {
    private final SettingsService settingsService;
    private final UserAccessor userAccessor;
    private final PermissionManager permissionManager;
    private final ScopeService scopeService;
    private final CQLSearchService cqlSearchService;
    private final PageManager pageManager;
    private final AnalysisService analysisService;
    private final ExtractionService extractionService;
    private final ExternalAPIService externalAPIService;
    private static final Logger logger = LoggerFactory.getLogger(SensitiveDataScanTask.class);

    protected SensitiveDataScanTask(TaskDBService taskDBService, int taskId, String paramsJson, ConfluenceUser actingUser, TransactionTemplate transactionTemplate, SettingsService settingsService, UserAccessor userAccessor, PermissionManager permissionManager, ScopeService scopeService, CQLSearchService cqlSearchService, PageManager pageManager, AnalysisService analysisService, ExtractionService extractionService, ExternalAPIService externalAPIService) {
        super(taskDBService, taskId, paramsJson, actingUser, transactionTemplate);
        this.settingsService = settingsService;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.scopeService = scopeService;
        this.cqlSearchService = cqlSearchService;
        this.pageManager = pageManager;
        this.analysisService = analysisService;
        this.extractionService = extractionService;
        this.externalAPIService = externalAPIService;
    }

    @Override
    public void execute() throws InterruptedException, TaskExecutionException {
        ScanSettings scanSettings = (ScanSettings)this.transactionTemplate.execute(this.settingsService::getScanSettings);
        if (scanSettings == null) {
            throw new TaskExecutionException("No Settings. Not Running Sensitive Data Scan.");
        }
        SensitiveDataScanParams params = (SensitiveDataScanParams)new Gson().fromJson(this.getParamsJson(), SensitiveDataScanParams.class);
        if (!params.isManual() && Boolean.FALSE.equals(scanSettings.getScheduled())) {
            throw new TaskExecutionException("Scheduled Scan Disabled, Not Running");
        }
        ConfluenceUser user = this.userAccessor.getUserByName(scanSettings.getActingUser());
        if (user == null) {
            throw new TaskExecutionException("Acting User Not Valid. Skipping");
        }
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            throw new TaskExecutionException("Acting User Not Confluence Admin. Not Running.");
        }
        ExternalAPIConfigReadOnly externalAPIConfig = (ExternalAPIConfigReadOnly)this.transactionTemplate.execute(this.externalAPIService::getAuthConfigReadOnly);
        if (externalAPIConfig != null && externalAPIConfig.isEnabled()) {
            try {
                this.externalAPIService.sendExternalAPIOptionsRequest(externalAPIConfig);
            }
            catch (Exception e) {
                this.addErrorLog(e.getMessage());
                throw new TaskExecutionException("Initial request to External API failed. Not Running.");
            }
        }
        AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
        this.addTaskLog(LogLevelEnum.INFO, "Starting scheduled analysis");
        ScopeBaseJson scope = (ScopeBaseJson)this.transactionTemplate.execute(this.scopeService::getScope);
        this.processSpaces(scope, scanSettings.getOnlyScanNewOrEdited() == null ? false : scanSettings.getOnlyScanNewOrEdited(), this.getStartOfLastScan(), (ExtractionEntity[])this.transactionTemplate.execute(this.extractionService::getEnabledExtractions), params.isManual());
        this.settingsService.setLastScheduledScan(new Date());
        this.addTaskLog(LogLevelEnum.INFO, this.isCancelled() ? "Cancelled scheduled analysis" : "Finished scheduled analysis");
    }

    private void processSpaces(ScopeBaseJson scope, boolean onlyScanNewOrEdited, @Nonnull Date lastScan, ExtractionEntity[] enabledExtractions, boolean isAutomated) throws TaskExecutionException {
        if (scope.getState() == ScopeEnum.DISABLED) {
            this.addTaskLog(LogLevelEnum.INFO, "Scan is disabled. skipping...");
            return;
        }
        String startOfLastScan = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(lastScan);
        this.addTaskLog(LogLevelEnum.INFO, "Last Scan Date was " + startOfLastScan);
        if (scope.getState() == ScopeEnum.ENABLED) {
            String query = this.getCQLQueries(scope, onlyScanNewOrEdited).get(0);
            int totalCount = this.cqlSearchService.countContent(query);
            this.addTaskLog(LogLevelEnum.INFO, String.format("Scan will process %s pages", totalCount));
            this.handleCQLQuery(query, enabledExtractions, scope.getState(), isAutomated, null, 1, totalCount);
            return;
        }
        if (scope.getState() == ScopeEnum.SPACES) {
            this.addTaskLog(LogLevelEnum.INFO, String.format("Scan will process %s spaces", scope.getSpaces().size()));
            for (int i = 0; i < scope.getSpaces().size(); ++i) {
                String query = this.getCQLQueries(new ScopeBaseJson(ScopeEnum.SPACES, Collections.singletonList(scope.getSpaces().get(i))), onlyScanNewOrEdited).get(0);
                this.handleCQLQuery(query, enabledExtractions, scope.getState(), isAutomated, scope.getSpaces().get(i), i, scope.getSpaces().size());
            }
        }
    }

    private void handleCQLQuery(String cql, ExtractionEntity[] enabledExtractions, ScopeEnum scopeState, boolean isAutomated, String spaceKey, int queryNo, int totalCount) throws TaskExecutionException {
        int pageCount = this.cqlSearchService.countContent(cql);
        int startAt = pageCount / 200 * 200;
        int batchNo = 1;
        boolean isCancelled = this.isCancelled();
        while (!isCancelled) {
            PageResponse pageResponse = this.cqlSearchService.searchContent(cql, (PageRequest)new SimplePageRequest(startAt, 200), new Expansion[]{new Expansion("space")});
            List pages = pageResponse.getResults();
            if (!pages.isEmpty() && scopeState == ScopeEnum.SPACES && batchNo == 1) {
                this.addTaskLog(LogLevelEnum.INFO, String.format("Scanning space %s, %s pages, %s/%s spaces scanned", spaceKey, pageCount, queryNo, totalCount));
            }
            if (!pages.isEmpty() && scopeState == ScopeEnum.ENABLED) {
                this.addTaskLog(LogLevelEnum.INFO, String.format("Scanning batch %s, %s/%s pages scanned", batchNo, pageCount - startAt, totalCount));
            }
            int[] counts = this.handlePages(pages, isAutomated, enabledExtractions);
            if (!pages.isEmpty()) {
                ++batchNo;
            }
            this.updateProgress(pages.size(), counts[0], counts[1], this.isCancelled());
            if (startAt <= 0) break;
            startAt = Math.max(startAt - 200, 0);
            isCancelled = this.isCancelled();
            if (pages.isEmpty() || isCancelled || counts[0] != 0 || counts[1] != 0) continue;
            throw new TaskExecutionException("Failed to successfully scan any pages in previous batch. Ending scan.");
        }
    }

    private static void logPagesToScan(List<Content> pages) {
        String pageIdString = pages.stream().map(page -> page.getId().asLong()).map(String::valueOf).collect(Collectors.joining(","));
        logger.warn(String.format("Scanning pages %s", pageIdString));
    }

    private int[] handlePages(List<Content> pages, boolean isAutomated, ExtractionEntity[] enabledExtractions) {
        SensitiveDataScanTask.logPagesToScan(pages);
        int successCount = 0;
        int warningCount = 0;
        for (Content result : pages) {
            if (this.isCancelled()) break;
            try {
                boolean scanned = (Boolean)this.transactionTemplate.execute(() -> {
                    Page page = this.pageManager.getPage(result.getId().asLong());
                    if (page == null) {
                        return false;
                    }
                    this.analysisService.processPage(page, "scheduled", isAutomated, true, enabledExtractions);
                    return true;
                });
                if (scanned) {
                    ++successCount;
                    continue;
                }
                this.addTaskLog(LogLevelEnum.WARNING, String.format("Page %d could not be found", result.getId().asLong()));
                ++warningCount;
            }
            catch (Exception e) {
                this.addTaskLog(LogLevelEnum.ERROR, e.getMessage(), result.getId().asLong(), result.getSpace().getId(), result.getSpace().getKey());
            }
        }
        return new int[]{successCount, warningCount};
    }

    private void updateProgress(int batchSize, int successCount, int warning, boolean cancelled) {
        this.transactionTemplate.execute(() -> {
            this.taskDBService.incrementTotalCount(this.taskId, batchSize);
            this.taskDBService.incrementSuccessValue(this.taskId, successCount);
            this.taskDBService.incrementWarningValue(this.taskId, warning);
            if (!cancelled) {
                this.taskDBService.incrementFailedValue(this.taskId, batchSize - successCount - warning);
            } else {
                this.taskDBService.updateSkipped(this.taskId);
            }
            return null;
        });
    }

    private Date getStartOfLastScan() {
        return (Date)this.transactionTemplate.execute(() -> {
            TaskJson lastScanTask = this.taskDBService.getLastSuccessfulTaskOfType(TaskTypeEnum.SENSITIVE_DATA_SCAN);
            return lastScanTask == null ? new Date(0L) : lastScanTask.getTimeStarted();
        });
    }

    private Date getStartOfCurrScan() {
        return (Date)this.transactionTemplate.execute(() -> this.taskDBService.getTask(this.taskId).getTimeStarted());
    }

    private String formatDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date);
    }

    private List<String> getSpaceQueries(List<String> spaceKeys, boolean onlyScanNewOrEdited) {
        int end;
        String startOfLastScan = this.formatDate(this.getStartOfLastScan());
        String startOfCurrScan = this.formatDate(this.getStartOfCurrScan());
        StringBuilder queryFormatBuilder = new StringBuilder();
        queryFormatBuilder.append(String.format("type = page AND lastmodified < '%s'", startOfCurrScan));
        if (onlyScanNewOrEdited) {
            queryFormatBuilder.append(" AND content.property[classificationanalysis].constant != 1");
            queryFormatBuilder.append(String.format(" AND lastmodified >= '%s'", startOfLastScan));
        }
        queryFormatBuilder.append(" AND space IN %s");
        queryFormatBuilder.append(" ORDER BY id");
        String queryFormat = queryFormatBuilder.toString();
        ArrayList<String> queries = new ArrayList<String>();
        for (int index = 0; index < spaceKeys.size(); index += end) {
            end = Math.min(index + 1024, spaceKeys.size());
            List<String> subList = spaceKeys.subList(index, end);
            String query = String.format(queryFormat, StringUtils.generateCommaSepListWrappedInBrackets(subList));
            queries.add(query);
        }
        return queries;
    }

    private List<String> getCQLQueries(ScopeBaseJson scope, boolean onlyScanNewOrEdited) {
        switch (scope.getState()) {
            case SPACES: {
                List<String> spaceKeys = scope.getSpaces().stream().map(String::toUpperCase).collect(Collectors.toList());
                return this.getSpaceQueries(spaceKeys, onlyScanNewOrEdited);
            }
            case ENABLED: {
                String startOfLastScan = this.formatDate(this.getStartOfLastScan());
                String startOfCurrScan = this.formatDate(this.getStartOfCurrScan());
                StringBuilder queryBuilder = new StringBuilder();
                queryBuilder.append(String.format("type = page AND lastmodified < '%s'", startOfCurrScan));
                if (onlyScanNewOrEdited) {
                    queryBuilder.append(" AND content.property[classificationanalysis].constant != 1");
                    queryBuilder.append(String.format(" AND lastmodified >= '%s'", startOfLastScan));
                }
                queryBuilder.append(" ORDER BY id");
                String query = queryBuilder.toString();
                return Collections.singletonList(query);
            }
        }
        return new ArrayList<String>();
    }
}

