/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.listener;

import co.uk.automationconsultants.compliance.exception.task.TaskCancellationException;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.TaskManager;
import co.uk.automationconsultants.compliance.task.event.AllNodesNotificationEvent;
import co.uk.automationconsultants.compliance.task.event.SingleNodeNotificationEvent;
import co.uk.automationconsultants.compliance.task.event.SingleNodeTaskCancellationEvent;
import co.uk.automationconsultants.compliance.utils.TaskClusterUtils;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named
public class TaskListener
implements DisposableBean {
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final ClusterManager clusterManager;
    private final TaskDBService taskDBService;
    private final TaskManager taskManager;
    private static final Logger logger = LoggerFactory.getLogger(TaskListener.class);

    @Inject
    public TaskListener(EventPublisher eventPublisher, TransactionTemplate transactionTemplate, ClusterManager clusterManager, TaskDBService taskDBService, TaskManager taskManager) {
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
        this.clusterManager = clusterManager;
        this.taskDBService = taskDBService;
        this.taskManager = taskManager;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void pluginFrameWorkStartedEventListener(PluginFrameworkStartedEvent event) {
        String clusterId = TaskClusterUtils.getClusterId(this.clusterManager);
        logger.info("Terminating Running tasks for Node {}.", (Object)clusterId);
        this.transactionTemplate.execute(() -> {
            this.taskDBService.terminateRunningTasks(clusterId);
            return null;
        });
    }

    @EventListener
    public void clusterEventWrapperListener(ClusterEventWrapper clusterEventWrapper) throws ReflectiveOperationException, TaskCancellationException {
        String clusterId = TaskClusterUtils.getClusterId(this.clusterManager);
        logger.debug("Cluster event was received with cluster Id {}", (Object)clusterId);
        try {
            Object event = ClusterEventWrapper.class.getMethod("getEvent", new Class[0]).invoke((Object)clusterEventWrapper, new Object[0]);
            if (event instanceof SingleNodeTaskCancellationEvent) {
                logger.debug("Cluster {} for single node task cancellation event with node Id {}", (Object)clusterId, (Object)((SingleNodeTaskCancellationEvent)((Object)event)).getElectedNodeId());
                if (clusterId.equals(((SingleNodeTaskCancellationEvent)((Object)event)).getElectedNodeId())) {
                    logger.debug("Running single node task cancellation event with task Id {}", (Object)((SingleNodeTaskCancellationEvent)((Object)event)).getTaskIdToCancel());
                    this.taskManager.cancelTask(((SingleNodeTaskCancellationEvent)((Object)event)).getTaskIdToCancel());
                }
            } else if (event instanceof SingleNodeNotificationEvent) {
                logger.debug("Cluster {} for single node task notification event with node Id {}", (Object)clusterId, (Object)((SingleNodeNotificationEvent)((Object)event)).getElectedNodeId());
                if (clusterId.equals(((SingleNodeNotificationEvent)((Object)event)).getElectedNodeId())) {
                    logger.debug("Running single node notification event on node {}", (Object)((SingleNodeNotificationEvent)((Object)event)).getElectedNodeId());
                    this.taskManager.notifyTaskScanner();
                }
            } else if (event instanceof AllNodesNotificationEvent) {
                logger.debug("Running cluster {} for all nodes notification event", (Object)clusterId);
                this.taskManager.notifyTaskScanner();
            } else {
                logger.debug("Cluster {} failed to understand event: {}", (Object)clusterId, (Object)(event != null ? event.getClass().getName() : "null"));
            }
        }
        catch (ReflectiveOperationException e) {
            logger.error("Error occurred while processing cluster event", (Throwable)e);
        }
    }

    @EventListener
    public void singleNodeNotificationEventListener(SingleNodeNotificationEvent event) {
        String clusterId = TaskClusterUtils.getClusterId(this.clusterManager);
        logger.debug("Single event - Single Node Task Notification event was received on node {}", (Object)clusterId);
        if (clusterId.equals(event.getElectedNodeId())) {
            logger.debug("Single event - Single Node Notification task is running on node {}", (Object)clusterId);
            this.taskManager.notifyTaskScanner();
        }
    }

    @EventListener
    public void singleNodeTaskCancellationEventListener(SingleNodeTaskCancellationEvent event) throws TaskCancellationException {
        String clusterId = TaskClusterUtils.getClusterId(this.clusterManager);
        logger.debug("Single event - Single Node Task Cancellation event was received on node {}", (Object)clusterId);
        if (clusterId.equals(event.getElectedNodeId())) {
            logger.debug("Single event - Cancelling task with ID {} running on node {}", (Object)event.getTaskIdToCancel(), (Object)clusterId);
            this.taskManager.cancelTask(event.getTaskIdToCancel());
        }
    }

    @EventListener
    public void allNodesNotificationEventListener(AllNodesNotificationEvent allNodesNotificationEvent) {
        logger.debug("Single event - All Nodes Notification event was received on node {}", (Object)TaskClusterUtils.getClusterId(this.clusterManager));
        this.taskManager.notifyTaskScanner();
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

