/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.entity.SettingEntity;
import co.uk.automationconsultants.compliance.entity.analysis.ExtractionResult;
import co.uk.automationconsultants.compliance.entity.automation.ActionInstance;
import co.uk.automationconsultants.compliance.entity.extractions.ExtractionEntity;
import co.uk.automationconsultants.compliance.json.analysis.AnalysisTrackerJson;
import co.uk.automationconsultants.compliance.json.settings.StatusJson;
import co.uk.automationconsultants.compliance.service.ExtractionService;
import co.uk.automationconsultants.compliance.service.LogService;
import co.uk.automationconsultants.compliance.service.ScopeService;
import co.uk.automationconsultants.compliance.service.settings.SettingsService;
import co.uk.automationconsultants.compliance.utils.JsonUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="analysisService")
public class AnalysisService {
    public static final String ANALYSIS_CP_KEY = "classificationanalysis";
    private static final Logger log = LoggerFactory.getLogger(AnalysisService.class);
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final ContentPropertyService contentPropertyService;
    @ComponentImport
    private final ContentService contentService;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final CQLSearchService cqlSearchService;
    private final LogService logService;
    private final ExtractionService extractionService;
    private final ScopeService scopeService;
    private final SettingsService settingsService;

    @Inject
    public AnalysisService(ActiveObjects activeObjects, ContentPropertyService contentPropertyService, ContentService contentService, PageManager pageManager, TransactionTemplate transactionTemplate, CQLSearchService cqlSearchService, LogService logService, ExtractionService extractionService, ScopeService scopeService, SettingsService settingsService) {
        this.activeObjects = activeObjects;
        this.contentPropertyService = contentPropertyService;
        this.contentService = contentService;
        this.pageManager = pageManager;
        this.transactionTemplate = transactionTemplate;
        this.cqlSearchService = cqlSearchService;
        this.logService = logService;
        this.extractionService = extractionService;
        this.scopeService = scopeService;
        this.settingsService = settingsService;
    }

    public void processPageRealTime(Page page, boolean isAutomatedAction) {
        SettingEntity[] settings;
        JsonContentProperty contentProperty = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(page.getContentId()).withPropertyKey(ANALYSIS_CP_KEY).fetchOrNull();
        if (contentProperty != null) {
            this.createOrUpdateAnalysisProperty((AbstractPage)page, 0);
        }
        if ((settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1))).length == 0 || Boolean.FALSE.equals(settings[0].getRealTimeScan())) {
            return;
        }
        if (page.getSpace() == null || !this.scopeService.inScope(page.getSpace(), this.scopeService.getScope())) {
            return;
        }
        this.transactionTemplate.execute(() -> {
            this.processPage(page, "realTime", isAutomatedAction, Boolean.TRUE.equals(settings[0].getRealTimeScanPrevVersions()), this.extractionService.getEnabledExtractions());
            return true;
        });
    }

    public void processPage(Page page, String origin, boolean isAutomatedAction, boolean scanPreviousVersions, ExtractionEntity[] enabledExtractions) {
        this.clearPreviousResults((AbstractPage)page);
        if (scanPreviousVersions) {
            for (int version = 1; version < page.getLatestVersion().getVersion(); ++version) {
                AbstractPage pageByVersion = this.pageManager.getPageByVersion((AbstractPage)page, version);
                if (pageByVersion != null) {
                    this.extractionService.handlePageExtractions(page.getId(), pageByVersion, page.getSpace(), enabledExtractions, origin, isAutomatedAction);
                    continue;
                }
                log.error("Error getting Page {} for Version {}", (Object)page.getId(), (Object)version);
            }
        }
        this.extractionService.handlePageExtractions(page.getId(), (AbstractPage)page, page.getSpace(), enabledExtractions, origin, isAutomatedAction);
        this.createOrUpdateAnalysisProperty((AbstractPage)page, 1);
    }

    public void processMaintenanceScan() {
        this.logService.addScanLog(AuthenticatedUserThreadLocal.getUsername(), "Maintenance: Deleting Entries", "init");
        this.activeObjects.executeInTransaction(() -> this.activeObjects.deleteWithSQL(ExtractionResult.class, "ID > 0", new Object[0]));
        this.logService.addScanLog(AuthenticatedUserThreadLocal.getUsername(), "Maintenance: Deleting Content Properties", "init");
        boolean isMore = true;
        int startAt = 0;
        while (isMore) {
            PageResponse results = this.cqlSearchService.searchContent("type = page", (PageRequest)new SimplePageRequest(startAt, 200), new Expansion[0]);
            for (Content result : results.getResults()) {
                this.transactionTemplate.execute(() -> {
                    JsonContentProperty versionCp;
                    Content content = (Content)this.contentService.find(new Expansion[0]).withId(result.getId()).fetchOrNull();
                    if (content != null && (versionCp = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(result.getId()).withPropertyKey(ANALYSIS_CP_KEY).fetchOrNull()) != null) {
                        this.contentPropertyService.delete(versionCp);
                    }
                    return true;
                });
            }
            isMore = results.hasMore();
        }
        this.settingsService.setLastScheduledScan(null);
        this.logService.addScanLog(AuthenticatedUserThreadLocal.getUsername(), "Maintenance: Running Scan", "init");
    }

    private void clearPreviousResults(AbstractPage page) {
        this.activeObjects.executeInTransaction(() -> {
            for (ExtractionResult extractionResult : (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "PAGE_ID = ? AND PAGE_VERSION < ? AND SPACE_ID = ? AND ACTIVE = ?", new Object[]{page.getId(), page.getLatestVersion().getVersion(), page.getSpace().getId(), true})) {
                extractionResult.setActive(false);
                extractionResult.save();
            }
            return true;
        });
    }

    public void createOrUpdateAnalysisProperty(AbstractPage page, int constant) {
        Content content = (Content)this.contentService.find(new Expansion[0]).withId(page.getContentId()).fetchOrNull();
        if (content == null) {
            log.error("Content not found for page: {}", (Object)page.getId());
            return;
        }
        String analysisJson = this.getAnalysisJsonString(new AnalysisTrackerJson(new Date(), page.getLatestVersion().getVersion(), constant));
        JsonContentProperty existingProperty = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(page.getContentId()).withPropertyKey(ANALYSIS_CP_KEY).fetchOrNull();
        JsonContentProperty.ContentPropertyBuilder propertyBuilder = JsonContentProperty.builder().content(content).key(ANALYSIS_CP_KEY).value(new JsonString(analysisJson));
        try {
            ValidationResult validationResult;
            JsonContentProperty property;
            if (existingProperty != null) {
                property = propertyBuilder.version(Objects.requireNonNull(existingProperty.getVersion()).nextBuilder().build()).build();
                validationResult = this.contentPropertyService.validator().validateUpdate(property);
                if (validationResult.isValid() && validationResult.isAuthorized()) {
                    this.contentPropertyService.update(property);
                    log.debug("Updated Content Property: {}", (Object)property.getValue().getValue());
                }
            } else {
                property = propertyBuilder.build();
                validationResult = this.contentPropertyService.validator().validateCreate(property);
                if (validationResult.isValid() && validationResult.isAuthorized()) {
                    this.contentPropertyService.create(property);
                    log.debug("Created Content Property: {}", (Object)property.getValue().getValue());
                }
            }
            if (!validationResult.isValid() || !validationResult.isAuthorized()) {
                log.debug("Failed to Create or Update Content Property: {}", (Object)property.getValue().getValue());
                validationResult.getErrors().forEach(e -> log.debug(e.getMessage().getTranslation()));
            }
        }
        catch (ServiceException e2) {
            log.error("Service Exception while attempting to create or update analysis content property: {}", (Object)e2.toString());
        }
    }

    private String getAnalysisJsonString(AnalysisTrackerJson json) {
        try {
            return JsonUtils.marshal(json);
        }
        catch (IOException e) {
            log.error("Error Marshalling Analysis Tracker JSON - {}", (Object)e.getMessage());
            return null;
        }
    }

    public void onDeletePage(Page page) {
        this.activeObjects.executeInTransaction(() -> {
            ExtractionResult[] extractionResults;
            for (ExtractionResult extractionResult : extractionResults = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, "PAGE_ID = ?", new Object[]{page.getLatestVersion().getId()})) {
                this.activeObjects.deleteWithSQL(ActionInstance.class, "EXTRACTION_RESULT_ID = ?", new Object[]{extractionResult.getID()});
            }
            this.activeObjects.deleteWithSQL(ExtractionResult.class, "PAGE_ID = ?", new Object[]{page.getLatestVersion().getId()});
            return null;
        });
    }

    public void onTrashPage(Page page) {
        this.activeObjects.executeInTransaction(() -> this.activeObjects.deleteWithSQL(ExtractionResult.class, "PAGE_ID = ?", new Object[]{page.getLatestVersion().getId()}));
    }

    public void onRestorePage(Page page) {
        this.processPageRealTime(page, true);
    }

    public StatusJson getStatus() {
        return this.scopeService.getStatus();
    }
}

