/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.entity.ComplianceNotification;
import co.uk.automationconsultants.compliance.entity.analysis.ExtractionResult;
import co.uk.automationconsultants.compliance.entity.automation.AutomationActionEntity;
import co.uk.automationconsultants.compliance.entity.automation.AutomationEntity;
import co.uk.automationconsultants.compliance.entity.automation.AutomationScopeEntity;
import co.uk.automationconsultants.compliance.entity.extractions.ExtractionEntity;
import co.uk.automationconsultants.compliance.exception.externalapi.ExternalAPINotConfiguredException;
import co.uk.automationconsultants.compliance.exception.externalapi.ExternalAPIResponseException;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigJson;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIRequest;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIResponse;
import co.uk.automationconsultants.compliance.json.level.LevelJson;
import co.uk.automationconsultants.compliance.service.AutomationService;
import co.uk.automationconsultants.compliance.service.ClassificationService;
import co.uk.automationconsultants.compliance.service.externalapi.ExternalAPIService;
import co.uk.automationconsultants.compliance.service.maintenance.ExtractionResultMaintenanceService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="extractionService")
public class ExtractionService {
    private static final Logger log = LoggerFactory.getLogger(ExtractionService.class);
    @ComponentImport
    private final ActiveObjects activeObjects;
    private final ClassificationService classificationService;
    @ComponentImport
    private final LabelManager labelManager;
    @ComponentImport
    private final PageManager pageManager;
    private final AutomationService automationService;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final ExtractionResultMaintenanceService extractionResultMaintenanceService;
    private final ExternalAPIService externalAPIService;
    private final SettingsManager settingsManager;

    @Inject
    public ExtractionService(ActiveObjects activeObjects, ClassificationService classificationService, LabelManager labelManager, PageManager pageManager, AutomationService automationService, UserAccessor userAccessor, ExtractionResultMaintenanceService extractionResultMaintenanceService, ExternalAPIService externalAPIService, SettingsManager settingsManager) {
        this.activeObjects = activeObjects;
        this.classificationService = classificationService;
        this.labelManager = labelManager;
        this.pageManager = pageManager;
        this.automationService = automationService;
        this.userAccessor = userAccessor;
        this.extractionResultMaintenanceService = extractionResultMaintenanceService;
        this.externalAPIService = externalAPIService;
        this.settingsManager = settingsManager;
    }

    public void handlePageExtractions(Long currentPageId, AbstractPage page, Space space, ExtractionEntity[] enabledExtractions, String origin, boolean isAutomatedAction) {
        try {
            ArrayList<String> externalAPIDetections = page.isLatestVersion() ? this.getDetectionsFromAPI(page, currentPageId) : new ArrayList();
            Map<String, Set<ExtractionEntity>> extractionMap = this.getExtractionsFromPage(page, enabledExtractions, externalAPIDetections);
            List<ExtractionResult> extractionResults = this.createExtractionResults(currentPageId, page, space, extractionMap, origin);
            this.handleAutomationRules(extractionResults, page, space, isAutomatedAction);
        }
        catch (ExternalAPINotConfiguredException | ExternalAPIResponseException | IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getDetectionsFromAPI(AbstractPage page, Long currentPageId) throws ExternalAPINotConfiguredException, ExternalAPIResponseException, GeneralSecurityException, IOException {
        ExternalAPIConfigJson configJson = this.externalAPIService.getAuthConfig();
        if (configJson != null && configJson.isEnabled()) {
            String body = page.getBodyContent().getContent().getBodyAsStringWithoutMarkup();
            String pageUrl = this.settingsManager.getGlobalSettings().getBaseUrl() + page.getUrlPath();
            ExternalAPIRequest externalAPIRequest = new ExternalAPIRequest(currentPageId.toString(), page.getTitle(), pageUrl, body, page.getCreator(), page.getLastModifier(), page.getVersion(), page.isLatestVersion(), page.getLastModificationDate().getTime());
            ExternalAPIResponse externalAPIResponse = this.externalAPIService.runExternalAPIRequest(externalAPIRequest);
            return externalAPIResponse.getDetectedText();
        }
        return new ArrayList<String>();
    }

    public ExtractionEntity[] getEnabledExtractions() {
        return (ExtractionEntity[])this.activeObjects.find(ExtractionEntity.class, "ENABLED = ?", new Object[]{true});
    }

    public int performExtractionResultMaintenance() {
        return this.extractionResultMaintenanceService.performMaintenance();
    }

    public int getInvalidExtractionResultsSize() {
        return this.extractionResultMaintenanceService.getInvalidEntriesSize();
    }

    private Map<String, Set<ExtractionEntity>> getExtractionsFromPage(AbstractPage page, ExtractionEntity[] enabledExtractions, List<String> externalAPIDetections) {
        String body = page.getBodyContent().getContent().getBodyAsStringWithoutMarkup();
        HashMap<String, Set<ExtractionEntity>> extractions = new HashMap<String, Set<ExtractionEntity>>();
        for (ExtractionEntity extractionEntity : enabledExtractions) {
            try {
                Matcher m = Pattern.compile(extractionEntity.getRegEx()).matcher(body);
                while (m.find()) {
                    MatchResult matchResult = m.toMatchResult();
                    extractions.computeIfAbsent(matchResult.group(), k -> new HashSet());
                    ((Set)extractions.get(matchResult.group())).add(extractionEntity);
                }
            }
            catch (Exception e) {
                log.error("Error Processing RegEx for Extraction: {} / {} ", (Object)extractionEntity.getName(), (Object)e.getMessage());
            }
        }
        ExtractionEntity[] externalEntity = (ExtractionEntity[])this.activeObjects.find(ExtractionEntity.class, Query.select().where("NAME = ? AND SYS_DEFINED = ?", new Object[]{"External Detection", true}));
        for (String externalDetection : externalAPIDetections) {
            extractions.computeIfAbsent(externalDetection, k -> new HashSet());
            ((Set)extractions.get(externalDetection)).add(externalEntity[0]);
        }
        return extractions;
    }

    private List<ExtractionResult> createExtractionResults(long currentPageId, AbstractPage page, Space space, Map<String, Set<ExtractionEntity>> extractions, String origin) {
        if (extractions == null) {
            return new ArrayList<ExtractionResult>();
        }
        return (List)this.activeObjects.executeInTransaction(() -> {
            ArrayList<ExtractionResult> extractionResults = new ArrayList<ExtractionResult>();
            for (Map.Entry entry : extractions.entrySet()) {
                String matchedString = (String)entry.getKey();
                for (ExtractionEntity extraction : (Set)entry.getValue()) {
                    matchedString = matchedString.trim();
                    int extractionCount = this.activeObjects.count(ExtractionResult.class, "EXTRACTION_ENTITY_ID = ? AND PAGE_ID = ? AND PAGE_VERSION = ? AND SPACE_ID = ? AND CAPTURED_TEXT = ?", new Object[]{extraction.getID(), currentPageId, page.getVersion(), space.getId(), matchedString});
                    if (matchedString.length() <= 0 || matchedString.length() > 255 || extractionCount != 0) continue;
                    ExtractionResult extractionResult = (ExtractionResult)this.activeObjects.create(ExtractionResult.class, new DBParam[]{new DBParam("EXTRACTION_ENTITY_ID", (Object)extraction.getID()), new DBParam("PAGE_ID", (Object)currentPageId), new DBParam("PAGE_VERSION", (Object)page.getVersion()), new DBParam("SPACE_ID", (Object)space.getId()), new DBParam("CAPTURED_TEXT", (Object)matchedString), new DBParam("DETECTION_DATE", (Object)new Date()), new DBParam("ACTIVE", (Object)page.isLatestVersion()), new DBParam("ORIGIN", (Object)origin)});
                    extractionResults.add(extractionResult);
                }
            }
            return extractionResults;
        });
    }

    private void handleAutomationRules(List<ExtractionResult> extractionResults, AbstractPage page, Space space, boolean isAutomatedAction) {
        AutomationEntity[] automationEntities;
        for (AutomationEntity automationEntity : automationEntities = (AutomationEntity[])this.activeObjects.find(AutomationEntity.class)) {
            AutomationScopeEntity[] scopes = automationEntity.getAutomationScopeEntities();
            for (ExtractionResult extractionResult : extractionResults) {
                ExtractionEntity extraction = extractionResult.getExtractionEntity();
                if (scopes.length == 0) {
                    this.performAutomatedActions(automationEntity, extraction, page, space, extractionResult, isAutomatedAction);
                    continue;
                }
                if (!Arrays.stream(scopes).anyMatch(scopeEntity -> scopeEntity.getSpaceKey().equalsIgnoreCase(page.getSpaceKey()))) continue;
                this.performAutomatedActions(automationEntity, extraction, page, space, extractionResult, isAutomatedAction);
            }
        }
    }

    private boolean performAction(AutomationActionEntity automationActionEntity, ExtractionResult extractionResult, AbstractPage page, Space space, ConfluenceUser user, boolean isAutomatedAction) {
        switch (automationActionEntity.getType()) {
            case "classify": {
                List<LevelJson> levels = this.classificationService.getLevels();
                Integer assignedLevel = automationActionEntity.getLevel();
                if (assignedLevel >= levels.size()) break;
                this.classificationService.performClassification(page.getId(), user, automationActionEntity.getLevel(), this.classificationService.getSpaceSettings(space.getKey()), levels, this.classificationService.getSettings(), isAutomatedAction);
                break;
            }
            case "redact": {
                this.automationService.redactSelectedItems(true, user, Collections.singletonList(extractionResult.getID()));
                break;
            }
            case "label": {
                String labelText = automationActionEntity.getLabel();
                labelText = labelText.replaceAll(" ", "-");
                labelText = labelText.replaceAll("[^a-zA-Z0-9_-]", "");
                if (labelText.isEmpty()) break;
                Label one = new Label(labelText);
                Label label = this.labelManager.getLabel(one);
                if (label == null) {
                    label = this.labelManager.createLabel(one);
                }
                this.labelManager.addLabel((Labelable)this.pageManager.getPage(page.getId()), label);
                break;
            }
            case "email": {
                log.debug("Adding email to queue. Extraction Result: {}, Recipient: {}", (Object)extractionResult.getCapturedText(), (Object)automationActionEntity.getUser());
                int previouslyCapturedNum = this.activeObjects.count(ExtractionResult.class, "PAGE_ID = ? AND PAGE_VERSION < ? AND SPACE_ID = ? AND CAPTURED_TEXT = ?", new Object[]{page.getId(), page.getLatestVersion().getVersion(), space.getId(), extractionResult.getCapturedText()});
                if (previouslyCapturedNum == 0) {
                    log.debug("This has not been captured before, adding to email queue");
                    this.activeObjects.create(ComplianceNotification.class, new DBParam[]{new DBParam("CREATION_DATE", (Object)new Date()), new DBParam("EXTRACTION_RESULT_ID", (Object)extractionResult), new DBParam("RECIPIENT", (Object)automationActionEntity.getUser())});
                    break;
                }
                log.debug("This has been captured before, not adding to email queue");
                break;
            }
            default: {
                log.debug("Compliance for Confluence - Automation - Unable to recognise action");
                return false;
            }
        }
        return true;
    }

    private void incrementExecutionCount(AutomationEntity automationEntity) {
        automationEntity.setExecutions(automationEntity.getExecutions() + 1);
        automationEntity.save();
    }

    private void performAutomatedActions(AutomationEntity automationEntity, ExtractionEntity extraction, AbstractPage page, Space space, ExtractionResult extractionResult, boolean isAutomatedAction) {
        try {
            ConfluenceUser user = this.userAccessor.getUserByName(automationEntity.getExecutionUser());
            if (user != null) {
                Set extractionIds = Arrays.stream(automationEntity.getExtractionEntities()).map(Entity::getID).collect(Collectors.toSet());
                boolean isActionExternalAPIDetection = automationEntity.getDetectionEnabled();
                if (isActionExternalAPIDetection) {
                    ExtractionEntity[] externalEntity = (ExtractionEntity[])this.activeObjects.find(ExtractionEntity.class, Query.select().where("NAME = ? AND SYS_DEFINED = ?", new Object[]{"External Detection", true}));
                    extractionIds.add(externalEntity[0].getID());
                }
                if (extractionIds.contains(extraction.getID())) {
                    boolean incrementExecution = false;
                    for (AutomationActionEntity action : automationEntity.getAutomationActionEntities()) {
                        incrementExecution |= this.performAction(action, extractionResult, page, space, user, isAutomatedAction);
                    }
                    if (incrementExecution) {
                        this.incrementExecutionCount(automationEntity);
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug("There was an error performing an automated action");
            log.debug(e.getMessage());
        }
    }
}

