/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.entity.ClassificationLevel;
import co.uk.automationconsultants.compliance.entity.SpaceSettingEntity;
import co.uk.automationconsultants.compliance.json.settings.SpaceSettingsJson;
import co.uk.automationconsultants.compliance.utils.LevelUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.java.ao.DBParam;
import net.java.ao.Query;

@Path(value="/spaceSetting")
public class SpaceSettingRest {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final SpaceManager spaceManager;

    @Inject
    public SpaceSettingRest(ActiveObjects activeObjects, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, SpaceManager spaceManager) {
        this.activeObjects = activeObjects;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getSpaceSettings(@Context HttpServletRequest request, @QueryParam(value="spaceKey") String spaceKey) {
        SpaceSettingEntity[] spaceSettings = (SpaceSettingEntity[])this.activeObjects.find(SpaceSettingEntity.class, Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey}));
        if (spaceSettings.length == 0) {
            return Response.ok((Object)new SpaceSettingsJson(-1)).build();
        }
        ClassificationLevel defaultLevel = spaceSettings[0].getSpaceDefaultLevel();
        Integer defaultLevelId = defaultLevel == null ? -1 : LevelUtils.getLegacyLevelIdFromEntity(this.activeObjects, defaultLevel);
        return Response.ok((Object)new SpaceSettingsJson(defaultLevelId)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response setSettings(@Context HttpServletRequest request, SpaceSettingsJson newSpaceSettings, @QueryParam(value="spaceKey") String spaceKey) {
        ClassificationLevel defaultLevel;
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        boolean isSpaceAdmin = this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)this.spaceManager.getSpace(spaceKey));
        if (!isSpaceAdmin) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SpaceSettingEntity[] spaceSettings = (SpaceSettingEntity[])this.activeObjects.find(SpaceSettingEntity.class, Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey}));
        ClassificationLevel[] classificationLevels = (ClassificationLevel[])this.activeObjects.find(ClassificationLevel.class);
        boolean isPendingLevel = newSpaceSettings.getSpaceDefaultLevel() == -1 || classificationLevels.length == 0;
        ClassificationLevel classificationLevel = defaultLevel = isPendingLevel ? null : classificationLevels[newSpaceSettings.getSpaceDefaultLevel()];
        if (spaceSettings.length == 0) {
            this.activeObjects.create(SpaceSettingEntity.class, new DBParam[]{new DBParam("SPACE_DEFAULT_LEVEL_ID", (Object)defaultLevel), new DBParam("SPACE_KEY", (Object)spaceKey)});
        } else {
            SpaceSettingEntity spaceSettingEntity = (SpaceSettingEntity)this.activeObjects.executeInTransaction(() -> {
                spaceSettings[0].setSpaceKey(spaceKey);
                spaceSettings[0].setSpaceDefaultLevel(defaultLevel);
                spaceSettings[0].save();
                return spaceSettings[0];
            });
        }
        return Response.ok().build();
    }
}

