/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.json.level.LevelRestrictionJson;
import co.uk.automationconsultants.compliance.json.page.PageClassificationValueJson;
import co.uk.automationconsultants.compliance.json.settings.GlobalSettingsJson;
import co.uk.automationconsultants.compliance.service.ClassificationService;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/enforce-restrictions")
public class EnforceRestrictionsRest {
    private static final Logger log = LoggerFactory.getLogger(EnforceRestrictionsRest.class);
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageManager pageManager;
    private final ClassificationService classificationService;
    @ComponentImport
    private final ContentPropertyService contentPropertyService;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final EntityManagerProvider entityManagerProvider;

    @Inject
    public EnforceRestrictionsRest(SpaceManager spaceManager, PageManager pageManager, ClassificationService classificationService, ContentPropertyService contentPropertyService, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, EntityManagerProvider entityManagerProvider) {
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.classificationService = classificationService;
        this.contentPropertyService = contentPropertyService;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.entityManagerProvider = entityManagerProvider;
    }

    @GET
    @Path(value="/global")
    @Produces(value={"application/json"})
    public Response enforceRestrictionsGlobally(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        boolean isConfAdmin = this.permissionManager.isConfluenceAdministrator((User)user);
        if (!isConfAdmin) {
            return Response.status((int)403).build();
        }
        List spaces = this.spaceManager.getAllSpaces();
        GlobalSettingsJson globalSettings = this.classificationService.getSettings();
        boolean restrictGloballyControlled = Boolean.TRUE.equals(globalSettings.getRestrictGloballyControlled());
        for (Space space : spaces) {
            List<LevelRestrictionJson> restrictions = null;
            if (restrictGloballyControlled) {
                restrictions = globalSettings.getRestrictions();
            } else if (this.classificationService.getSpaceSettings(space.getKey()) != null) {
                restrictions = this.classificationService.getSpaceSettings((String)space.getKey()).levelRestrictions;
            }
            if (restrictions != null) {
                this.enforceSpace(restrictions, space, user, globalSettings);
            }
            this.entityManagerProvider.getEntityManager().clear();
        }
        return Response.ok().build();
    }

    private void enforceSpace(List<LevelRestrictionJson> restrictions, Space space, ConfluenceUser user, GlobalSettingsJson globalSettings) {
        if (restrictions != null) {
            for (Page page : this.pageManager.getPages(space, true)) {
                if (page == null) continue;
                log.debug("Compliance for Confluence - Enforce Restrictions - Analysing page: " + page.getTitle());
                HashSet<String> setGroupPermission = new HashSet<String>();
                HashSet<String> setUserPermission = new HashSet<String>();
                JsonContentProperty existingLevel = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(page.getContentId()).withPropertyKey("classification").fetchOneOrNull();
                String classificationLevelName = "";
                if (existingLevel != null) {
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        PageClassificationValueJson pageClassificationValueJson = (PageClassificationValueJson)mapper.readValue(existingLevel.getValue().getValue(), PageClassificationValueJson.class);
                        classificationLevelName = pageClassificationValueJson.name.value;
                        for (LevelRestrictionJson json : restrictions) {
                            if (!json.getName().equals(classificationLevelName)) continue;
                            setGroupPermission.addAll(json.getGroups());
                            setUserPermission.addAll(json.getusers());
                        }
                        HashSet<String> actualGroupPermission = new HashSet<String>();
                        HashSet<String> actualUserPermission = new HashSet<String>();
                        if (page.hasContentPermissions()) {
                            ContentPermissionSet contentPermissions = page.getContentPermissionSet("Edit");
                            if (contentPermissions != null) {
                                for (ContentPermission cp : contentPermissions) {
                                    if (cp.isGroupPermission()) {
                                        actualGroupPermission.add(cp.getGroupName().toLowerCase());
                                        continue;
                                    }
                                    if (!cp.isUserPermission()) continue;
                                    actualUserPermission.add(cp.getUserSubject().getLowerName());
                                }
                                if (setGroupPermission.equals(actualGroupPermission) && setUserPermission.equals(actualUserPermission)) {
                                    log.debug("Compliance for Confluence - Enforce Restrictions - The restrictions are consistent with page: " + page.getContentId());
                                    continue;
                                }
                                log.debug("Compliance for Confluence - Enforce Restrictions - The restrictions are NOT consistent with page: " + page.getContentId());
                                this.fixRestrictions(page, user, globalSettings);
                                continue;
                            }
                            log.debug("Compliance for Confluence - Enforce Restrictions - Could not find permissions for page: " + page.getContentId());
                            continue;
                        }
                        if (setUserPermission.isEmpty() && setGroupPermission.isEmpty() && !page.hasContentPermissions()) {
                            log.debug("Compliance for Confluence - Enforce Restrictions - The restrictions are consistent with page: " + page.getContentId());
                            continue;
                        }
                        log.debug("Compliance for Confluence - Enforce Restrictions - The restrictions are NOT consistent with page: " + page.getContentId());
                        this.fixRestrictions(page, user, globalSettings);
                    }
                    catch (IOException ex) {
                        log.debug("Compliance for Confluence - Enforce Restrictions - Exception occurred: " + ex.getMessage());
                    }
                    continue;
                }
                log.debug("Compliance for Confluence - Enforce Restrictions - The page is not classified: " + page.getContentId());
            }
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response enforceRestrictions(@Context HttpServletRequest request, @QueryParam(value="spaceKey") String spaceKey) {
        List<LevelRestrictionJson> restrictions;
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        boolean isSpaceAdmin = this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)this.spaceManager.getSpace(spaceKey));
        if (!isSpaceAdmin) {
            return Response.status((int)403).build();
        }
        GlobalSettingsJson globalSettings = this.classificationService.getSettings();
        boolean restrictGloballyControlled = Boolean.TRUE.equals(globalSettings.getRestrictGloballyControlled());
        Space space = this.spaceManager.getSpace(spaceKey);
        if (restrictGloballyControlled) {
            restrictions = globalSettings.getRestrictions();
        } else if (space != null && this.classificationService.getSpaceSettings(space.getKey()) != null) {
            restrictions = this.classificationService.getSpaceSettings((String)space.getKey()).levelRestrictions;
        } else {
            return Response.ok().build();
        }
        if (restrictions != null) {
            this.enforceSpace(restrictions, space, user, globalSettings);
        }
        return Response.ok().build();
    }

    private void fixRestrictions(Page page, ConfluenceUser user, GlobalSettingsJson settings) throws IOException {
        JsonContentProperty existingLevel = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(page.getContentId()).withPropertyKey("classification").fetchOneOrNull();
        if (existingLevel != null) {
            ObjectMapper mapper = new ObjectMapper();
            PageClassificationValueJson pageClassificationValueJson = (PageClassificationValueJson)mapper.readValue(existingLevel.getValue().getValue(), PageClassificationValueJson.class);
            this.classificationService.performClassification(page.getId(), user, pageClassificationValueJson.name.index, this.classificationService.getSpaceSettings(page.getSpaceKey()), this.classificationService.getLevels(), settings, false);
            log.debug("Fixed restrictions for page: " + page.getContentId());
        }
    }
}

