/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task.search;

import co.uk.automationconsultants.compliance.json.task.TaskLogJson;
import co.uk.automationconsultants.compliance.json.task.search.LogSearchCursor;
import co.uk.automationconsultants.compliance.json.task.search.TaskLogSearchFilterJson;
import co.uk.automationconsultants.compliance.task.search.SearchHelper;
import co.uk.automationconsultants.compliance.utils.StringUtils;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.Query;

public class TaskLogSearchHelper
implements SearchHelper<LogSearchCursor, TaskLogSearchFilterJson, TaskLogJson> {
    @Override
    public LogSearchCursor parseCursor(String cursor) {
        try {
            String decodedCursor = new String(Base64.getDecoder().decode(cursor));
            String[] values = decodedCursor.split("_");
            boolean isNext = values[0].equals("next");
            long timeStamp = Long.parseLong(values[1]);
            return new LogSearchCursor(isNext, timeStamp);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Query generateQuery(LogSearchCursor searchCursor, TaskLogSearchFilterJson filter, int limit, boolean oldestFirst) {
        return this.generateBaseQuery(filter, searchCursor, oldestFirst).limit(limit + 1).order(this.generateOrderClause(searchCursor, oldestFirst));
    }

    @Override
    public Query generateCountQuery(TaskLogSearchFilterJson filter) {
        return this.generateBaseQuery(filter, null, false);
    }

    @Override
    public String generatePrevCursor(LogSearchCursor searchCursor, List<TaskLogJson> results, boolean isMore) {
        if (searchCursor == null || !isMore && !searchCursor.isNext()) {
            return null;
        }
        long timeStamp = results.get(0).getTimeCreated().getTime();
        String cursor = "prev_" + timeStamp;
        return Base64.getEncoder().encodeToString(cursor.getBytes());
    }

    @Override
    public String generateNextCursor(LogSearchCursor searchCursor, List<TaskLogJson> results, boolean isMore) {
        if (!isMore && (searchCursor == null || searchCursor.isNext())) {
            return null;
        }
        long timeStamp = results.get(results.size() - 1).getTimeCreated().getTime();
        String cursor = "next_" + timeStamp;
        return Base64.getEncoder().encodeToString(cursor.getBytes());
    }

    private Query generateBaseQuery(TaskLogSearchFilterJson filter, LogSearchCursor searchCursor, boolean oldestFirst) {
        return Query.select().where(this.generateWhereClause(filter, searchCursor, oldestFirst), this.getWhereClauseParams(searchCursor, filter));
    }

    private Object[] getWhereClauseParams(LogSearchCursor cursor, TaskLogSearchFilterJson filter) {
        if (filter == null && cursor == null) {
            return new Object[0];
        }
        if (filter == null) {
            return new Object[]{new Date(cursor.getTimeCreated())};
        }
        if (cursor == null) {
            return new Object[]{filter.getTaskId()};
        }
        return new Object[]{filter.getTaskId(), new Date(cursor.getTimeCreated())};
    }

    private String generateOrderClause(LogSearchCursor searchCursor, boolean oldestFirst) {
        if (!oldestFirst) {
            return searchCursor == null || searchCursor.isNext() ? "TIME_CREATED DESC" : "TIME_CREATED ASC";
        }
        return searchCursor == null || searchCursor.isNext() ? "TIME_CREATED ASC" : "TIME_CREATED DESC";
    }

    private String generateWhereClauseNoCursor(TaskLogSearchFilterJson filter) {
        if (filter == null) {
            return null;
        }
        String taskIdClause = "TASK_ID = ?";
        String logLevelClause = filter.getLogLevels() == null || filter.getLogLevels().isEmpty() ? "" : " AND LOG_LEVEL IN " + StringUtils.generateCommaSepListWrappedInBrackets(filter.getLogLevels());
        return taskIdClause + logLevelClause;
    }

    private String generateWhereClause(TaskLogSearchFilterJson filter, LogSearchCursor searchCursor, boolean oldestFirst) {
        String whereClause;
        String whereClauseNoCursor = this.generateWhereClauseNoCursor(filter);
        String cursorClause = null;
        if (searchCursor != null) {
            cursorClause = oldestFirst ? (searchCursor.isNext() ? "TIME_CREATED > ?" : "TIME_CREATED < ?") : (searchCursor.isNext() ? "TIME_CREATED < ?" : "TIME_CREATED > ?");
        }
        return (whereClause = Stream.of(whereClauseNoCursor, cursorClause).filter(Objects::nonNull).collect(Collectors.joining(" AND "))).isEmpty() ? null : whereClause;
    }
}

