/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task;

import co.uk.automationconsultants.compliance.exception.task.InvalidParamsException;
import co.uk.automationconsultants.compliance.exception.task.InvalidTaskTypeException;
import co.uk.automationconsultants.compliance.exception.task.TaskCancellationException;
import co.uk.automationconsultants.compliance.json.task.TaskCreationJson;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.service.task.TaskExecutionService;
import co.uk.automationconsultants.compliance.task.TaskScanner;
import co.uk.automationconsultants.compliance.task.delegation.TaskDelegationService;
import co.uk.automationconsultants.compliance.task.delegation.TaskDelegator;
import co.uk.automationconsultants.compliance.utils.TaskClusterUtils;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="taskManager")
public class TaskManager {
    private final TaskDBService taskDBService;
    @ComponentImport
    private final ClusterManager clusterManager;
    private final TaskScanner taskScanner;
    private final TaskDelegator taskDelegator;
    private final TaskExecutionService taskExecutionService;
    private static final Logger logger = LoggerFactory.getLogger(TaskManager.class);

    @Inject
    public TaskManager(TaskDBService taskDBService, ClusterManager clusterManager, TaskDelegationService taskDelegationService, TaskExecutionService taskExecutionService, TransactionTemplate transactionTemplate, ClusterLockService clusterLockService) {
        this.taskDBService = taskDBService;
        this.clusterManager = clusterManager;
        this.taskExecutionService = taskExecutionService;
        this.taskScanner = new TaskScanner(taskDBService, clusterManager.getThisNodeInformation(), taskExecutionService, transactionTemplate);
        this.taskDelegator = new TaskDelegator(taskDelegationService, taskDBService, transactionTemplate, clusterManager.getThisNodeInformation(), clusterLockService, this.taskScanner);
        this.taskScanner.startThread();
        logger.debug("Initialised scanning thread");
        this.taskDelegator.startThread();
        logger.debug("Initialised delegation thread");
    }

    public TaskJson addTask(TaskCreationJson taskCreationJson, String creator) throws InvalidParamsException, InvalidTaskTypeException {
        String clusterIdentifier = TaskClusterUtils.getClusterId(this.clusterManager);
        TaskJson task = this.taskDBService.addTask(taskCreationJson, clusterIdentifier, creator);
        logger.debug("Task {} has been added to db. Manager node = {}", (Object)task.getId(), (Object)clusterIdentifier);
        CompletableFuture.runAsync(this.taskDelegator::alertDelegator);
        return task;
    }

    public void notifyTaskScanner() {
        this.taskScanner.alertScanner();
    }

    public void cancelTask(int id) throws TaskCancellationException {
        this.taskExecutionService.cancelTask(id);
    }

    public boolean isExecutorBusy() {
        return this.taskExecutionService.isBusy();
    }
}

