/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service.settings;

import co.uk.automationconsultants.compliance.entity.ClassificationLevel;
import co.uk.automationconsultants.compliance.entity.SettingEntity;
import co.uk.automationconsultants.compliance.entity.SpaceSettingEntity;
import co.uk.automationconsultants.compliance.json.level.LevelRestrictionJson;
import co.uk.automationconsultants.compliance.json.settings.ScanSettings;
import co.uk.automationconsultants.compliance.service.settings.SettingsService;
import co.uk.automationconsultants.compliance.utils.LevelUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SettingsServiceImpl
implements SettingsService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    private static final Logger log = LoggerFactory.getLogger(SettingsServiceImpl.class);

    @Inject
    public SettingsServiceImpl(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Override
    public List<LevelRestrictionJson> getRestrictions() {
        SettingEntity settings = ((SettingEntity[])this.activeObjects.find(SettingEntity.class))[0];
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (List)objectMapper.readValue(settings.getRestrictions(), (TypeReference)new TypeReference<List<LevelRestrictionJson>>(){});
        }
        catch (IOException e) {
            log.debug("Failed to deserialize restrictions field from settings DB: {}", (Object)e.getMessage());
            return null;
        }
        catch (IllegalArgumentException e) {
            log.debug("Restrictions field in settings DB is null, cannot deserialize");
            return null;
        }
    }

    @Override
    public void setRestrictions(List<LevelRestrictionJson> restrictions) {
        SettingEntity settings = ((SettingEntity[])this.activeObjects.find(SettingEntity.class))[0];
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String restrictionsStr = objectMapper.writeValueAsString(restrictions);
            this.activeObjects.executeInTransaction(() -> {
                settings.setRestrictions(restrictionsStr);
                settings.save();
                return settings;
            });
        }
        catch (IOException e) {
            log.debug("Serialization failed when attempting to set restrictions in settings DB: {}", (Object)e.getMessage());
        }
    }

    @Override
    public Integer getDefaultLevel(String spaceKey) {
        SettingEntity[] settingsList = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
        if (settingsList.length == 0) {
            return -1;
        }
        SettingEntity settings = settingsList[0];
        if (settings.getManageDefaultLevelGlobally() != null && settings.getManageDefaultLevelGlobally().booleanValue()) {
            return settings.getGlobalDefaultLevel() == null ? -1 : settings.getGlobalDefaultLevel();
        }
        SpaceSettingEntity[] spaceSettingEntities = (SpaceSettingEntity[])this.activeObjects.find(SpaceSettingEntity.class, "SPACE_KEY = ?", new Object[]{spaceKey});
        ClassificationLevel spaceDefaultLevel = spaceSettingEntities.length != 1 ? null : spaceSettingEntities[0].getSpaceDefaultLevel();
        return spaceDefaultLevel == null ? -1 : LevelUtils.getLegacyLevelIdFromEntity(this.activeObjects, spaceDefaultLevel);
    }

    @Override
    @Nullable
    public ScanSettings getScanSettings() {
        SettingEntity[] settingsList = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
        if (settingsList.length == 0) {
            return null;
        }
        SettingEntity settings = settingsList[0];
        return new ScanSettings(settings.getRealTimeScan(), settings.getRealTimeScanPrevVersions(), settings.getScheduledScan(), settings.getActingUser(), settings.getOnlyScanNewOrEdited(), settings.getLastScheduledScan());
    }

    @Override
    public void setLastScheduledScan(Date date) {
        this.activeObjects.executeInTransaction(() -> {
            SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
            if (settings.length != 0) {
                settings[0].setLastScheduledScan(date);
                settings[0].save();
            }
            return null;
        });
    }
}

