/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.json.settings.LicenseJson;
import co.uk.automationconsultants.compliance.service.ComplianceLicenseService;
import co.uk.automationconsultants.compliance.service.enumerator.LicenseType;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/license")
public class LicenseRest {
    @ComponentImport
    private final LicenseService licenseService;
    private final ComplianceLicenseService complianceLicenseService;

    @Inject
    public LicenseRest(LicenseService licenseService, ComplianceLicenseService complianceLicenseService) {
        this.licenseService = licenseService;
        this.complianceLicenseService = complianceLicenseService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getLicense(@Context HttpServletRequest request) {
        LicenseType complianceLicense = this.complianceLicenseService.getLicense();
        if (complianceLicense == LicenseType.NO_LICENSE) {
            return Response.ok((Object)new LicenseJson("none")).build();
        }
        if (complianceLicense == LicenseType.EVAL_LICENSE) {
            return Response.ok((Object)new LicenseJson("true")).build();
        }
        if (complianceLicense == LicenseType.FULL_LICENSE) {
            return Response.ok((Object)new LicenseJson("true")).build();
        }
        return Response.ok((Object)new LicenseJson("none")).build();
    }
}

