$(function() {
    var page = $(".page");
    var byline = $("#sensitive-data-page-byline");
    var bylineWrapper = $("#sensitive-data-page-byline-wrapper");
    
    function getExtractions() {
        return new Promise(function (resolve, reject) {
            var vid = $("meta[name='page-version']").attr("content");
            $.ajax({
                url: AJS.contextPath() + "/rest/server-classification/1.0/analysis/page?pid=" + AJS.params.pageId,
                contentType: "application/json",
                success: function (data) { resolve(data); },
                error: function () { reject(); },
                headers: { "Accept": "application/json" }
            });
        });
    }

    function appendInlineDialog() {
        page.append(
            '<aui-inline-dialog alignment="bottom left" id="byline-sensitivity-expansion">' +
                '<div id="sensitivity-byline-root" class="container sensitivity-container">' + AJS.I18n.getText("compliance.plugin.js.loading") + '</div>' +
            '</aui-inline-dialog>');
        byline.attr('aria-controls', 'byline-sensitivity-expansion');
        byline.attr('data-aui-trigger', true);
        byline.removeAttr("href");
        byline.click(function() {
            WRM.require("co.uk.jackgraves.classification.server-classification:compliance-react-resources", function () {
                complianceForConfluence.renderSensitivity("sensitivity-byline-root");
            });
        });
    }
    
    function appendBylineItem(count) {
        bylineWrapper.css("position", "relative").css("bottom", "4px");
        byline.html("<span style=\"bottom:1px;position:relative;font-size:11px;\" class=\"aui-lozenge aui-lozenge-subtle\">" + count + " " + (count === 1 ? AJS.I18n.getText("compliance.plugin.js.item") : AJS.I18n.getText("compliance.plugin.js.items")) + "</span>");
        byline.attr("title", count + " " + AJS.I18n.getText("compliance.plugin.js.sensitive.entries"));
    }

    if (AJS.params.pageId) {
        getExtractions().then(function (extractions) {
            if (extractions.length > 0) {
                appendBylineItem(extractions.length);
                appendInlineDialog();
            } else {
                byline.hide();
            }
        });
    }
});
