/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.utils;

import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchV2Utils {
    private static final Logger log = LoggerFactory.getLogger(SearchV2Utils.class);
    public static final String CLASSIFICATION_NAME_SEARCH = "content-property-classification-name.search";
    public static final String CLASSIFICATION_NAME_VALUE = "content-property-classification-name.value";
    public static final String CLASSIFICATION_NAME_INDEX = "content-property-classification-name.index";
    public static final String CLASSIFICATION_ANALYSIS_VERSION = "content-property-classificationanalysis-version";
    public static final String CLASSIFICATION_ANALYSIS_DATE = "content-property-classificationanalysis-date";
    public static final String CLASSIFICATION_ANALYSIS_CONSTANT = "content-property-classificationanalysis-constant";
    public static final String CLASSIFICATION_HISTORY_LEVEL_RESTRICTIONS = "content-property-classificationhistory-levelRestrictions";

    private SearchV2Utils() {
    }

    public static ContentSearch initContentSearch(SearchQuery query, SearchSort sort) throws ReflectiveOperationException {
        try {
            Constructor ctr = ContentSearch.class.getConstructor(SearchQuery.class, SearchSort.class);
            return (ContentSearch)ctr.newInstance(query, sort);
        }
        catch (NoSuchMethodException e) {
            log.debug("New ContentSearch constructor not found, falling back to old constructor...");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.debug("Found new ContentSearch constructor, but could not instantiate with it");
        }
        try {
            Constructor<?>[] ctrs;
            for (Constructor<?> ctr : ctrs = ContentSearch.class.getConstructors()) {
                if (ctr.getGenericParameterTypes().length != 4) continue;
                return (ContentSearch)ctr.newInstance(query, sort, null, null);
            }
            log.debug("Could not find old ContentSearch constructor with desired signature");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.debug("Found old ContentSearch constructor, but could not instantiate with it");
        }
        log.debug("Attempt to re-instantiate new constructor, if it fails throw a ReflectiveOperationException");
        Constructor ctr = ContentSearch.class.getConstructor(SearchQuery.class, SearchSort.class);
        return (ContentSearch)ctr.newInstance(query, sort);
    }
}

