/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service.externalapi;

import co.uk.automationconsultants.compliance.entity.externalapi.ExternalAPIConfig;
import co.uk.automationconsultants.compliance.exception.externalapi.ExternalAPINotConfiguredException;
import co.uk.automationconsultants.compliance.exception.externalapi.ExternalAPIResponseException;
import co.uk.automationconsultants.compliance.json.externalapi.AuthHeader;
import co.uk.automationconsultants.compliance.json.externalapi.CustomResponseDeserializer;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigJson;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigPayload;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigReadOnly;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIRequest;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIResponse;
import co.uk.automationconsultants.compliance.json.externalapi.ResponseStatus;
import co.uk.automationconsultants.compliance.service.externalapi.GlobalKeyPairService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Base64;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import net.java.ao.DBParam;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ExternalAPIService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    private final GlobalKeyPairService globalKeyPairService;
    private static final Logger log = LoggerFactory.getLogger(ExternalAPIService.class);

    public ExternalAPIService(ActiveObjects activeObjects, GlobalKeyPairService globalKeyPairService) {
        this.activeObjects = activeObjects;
        this.globalKeyPairService = globalKeyPairService;
    }

    public ExternalAPIConfigJson createConfig(ExternalAPIConfigPayload payload) throws GeneralSecurityException {
        KeyPair keyPair = this.globalKeyPairService.getKeyPair();
        String username = payload.getAuthHeader().equals((Object)AuthHeader.BASIC) ? payload.getUsername() : null;
        String[] encrypted = this.globalKeyPairService.encryptUsernameAndToken(keyPair, username, payload.getToken());
        ExternalAPIConfig externalAPIConfig = (ExternalAPIConfig)this.activeObjects.create(ExternalAPIConfig.class, new DBParam[]{new DBParam("ENABLED", (Object)Boolean.TRUE.equals(payload.getEnabled())), new DBParam("URL", (Object)payload.getUrl()), new DBParam("AUTH_HEADER", (Object)payload.getAuthHeader().name()), new DBParam("USERNAME", (Object)encrypted[0]), new DBParam("TOKEN", (Object)encrypted[1])});
        return this.toExternalAPIConfigJson(externalAPIConfig, keyPair);
    }

    @Nullable
    public ExternalAPIConfigReadOnly getAuthConfigReadOnly() {
        ExternalAPIConfig configFromDB = this.getExternalConfigFromDB();
        return this.toExternalAPIConfigReadOnly(configFromDB);
    }

    @Nullable
    public ExternalAPIConfigJson getAuthConfig() throws GeneralSecurityException {
        ExternalAPIConfig configFromDB = this.getExternalConfigFromDB();
        KeyPair keyPair = this.globalKeyPairService.getKeyPair();
        return this.toExternalAPIConfigJson(configFromDB, keyPair);
    }

    @Nullable
    private ExternalAPIConfigJson decryptUsernameAndToken(ExternalAPIConfigJson externalAPIConfigJson) throws GeneralSecurityException {
        KeyPair keyPair = this.globalKeyPairService.getKeyPair();
        String username = this.globalKeyPairService.decryptString(keyPair, externalAPIConfigJson.getUsername());
        String token = this.globalKeyPairService.decryptString(keyPair, externalAPIConfigJson.getToken());
        return new ExternalAPIConfigJson(externalAPIConfigJson.isEnabled(), externalAPIConfigJson.getUrl(), externalAPIConfigJson.getAuthHeader(), username, token);
    }

    @Nullable
    public ExternalAPIConfigJson getDecryptedConfig(ExternalAPIConfigJson externalAPIConfigJson) throws GeneralSecurityException {
        return this.decryptUsernameAndToken(externalAPIConfigJson);
    }

    public ExternalAPIConfigJson updateAuthConfig(ExternalAPIConfigPayload payload) throws GeneralSecurityException {
        ExternalAPIConfig configFromDB = this.updateAuthConfigFromDB(payload);
        KeyPair keyPair = this.globalKeyPairService.getKeyPair();
        return this.toExternalAPIConfigJson(configFromDB, keyPair);
    }

    public ExternalAPIConfigReadOnly updateAuthConfigReadOnly(ExternalAPIConfigPayload payload) throws GeneralSecurityException {
        ExternalAPIConfig configFromDB = this.updateAuthConfigFromDB(payload);
        return this.toExternalAPIConfigReadOnly(configFromDB);
    }

    public boolean hasBeenConfigured() {
        return this.getExternalConfigFromDB() != null;
    }

    public void sendExternalAPIOptionsRequest(ExternalAPIConfigReadOnly config) throws IOException {
        log.debug("Sending test options request to External API...");
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();){
            httpClient.execute((HttpUriRequest)new HttpOptions(config.getUrl()));
        }
        log.debug("Test options request for External API successful");
    }

    public ExternalAPIResponse runExternalAPIRequest(@Nonnull ExternalAPIRequest request) throws GeneralSecurityException, ExternalAPINotConfiguredException, ExternalAPIResponseException, IOException {
        ExternalAPIConfigJson config = this.getAuthConfig();
        if (config == null || !config.isEnabled()) {
            throw new ExternalAPINotConfiguredException();
        }
        log.debug("Sending External API request...");
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();){
            ExternalAPIResponse externalAPIResponse;
            HttpResponse response = this.performHttpRequest(request, config, httpClient);
            log.debug("Response from External API received, deserializing...");
            ExternalAPIResponse externalAPIResponse2 = externalAPIResponse = this.deserializeResponse(response);
            return externalAPIResponse2;
        }
    }

    private HttpResponse performHttpRequest(ExternalAPIRequest request, ExternalAPIConfigJson config, CloseableHttpClient httpClient) throws ExternalAPIResponseException, IOException {
        HttpPost httpPost = this.getHttpPost(request, config);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new ExternalAPIResponseException(response.getStatusLine(), EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return response;
    }

    private HttpPost getHttpPost(ExternalAPIRequest request, ExternalAPIConfigJson config) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(config.getUrl());
        httpPost.setHeader("Content-Type", "application/json");
        String body = new Gson().toJson((Object)request);
        httpPost.setEntity((HttpEntity)new StringEntity(body));
        if (config.getAuthHeader().equals((Object)AuthHeader.BEARER)) {
            httpPost.setHeader("Authorization", "Bearer " + config.getToken());
        } else if (config.getAuthHeader().equals((Object)AuthHeader.BASIC)) {
            String passPhrase = config.getUsername() + ":" + config.getToken();
            String encodedString = Base64.getEncoder().encodeToString(passPhrase.getBytes(StandardCharsets.UTF_8));
            httpPost.setHeader("Authorization", "Basic " + encodedString);
        }
        return httpPost;
    }

    private ExternalAPIResponse deserializeResponse(HttpResponse response) throws ExternalAPIResponseException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("CustomJacksonDeserializer", new Version(1, 0, 0, "FINAL"));
        module.addDeserializer(ExternalAPIResponse.class, (JsonDeserializer)new CustomResponseDeserializer());
        mapper.registerModule((Module)module);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        try {
            ExternalAPIResponse externalAPIResponse = (ExternalAPIResponse)mapper.readValue(responseBody, ExternalAPIResponse.class);
            if (externalAPIResponse.getStatus() == ResponseStatus.FAIL) {
                boolean hasErrorMsg = externalAPIResponse.getErrorMessage() != null;
                throw new ExternalAPIResponseException(response.getStatusLine(), responseBody, hasErrorMsg ? externalAPIResponse.getErrorMessage() : "External API returned a responseStatus of FAIL");
            }
            return externalAPIResponse;
        }
        catch (JsonParseException e) {
            throw new ExternalAPIResponseException(response.getStatusLine(), responseBody, "Body returned is improperly formatted or not JSON.");
        }
        catch (MismatchedInputException e) {
            throw new ExternalAPIResponseException(response.getStatusLine(), responseBody, "No body returned for response.");
        }
    }

    private boolean shouldUpdateUsername(AuthHeader header) {
        return header == null || header.equals((Object)AuthHeader.BASIC);
    }

    private ExternalAPIConfig updateAuthConfigFromDB(ExternalAPIConfigPayload payload) throws GeneralSecurityException {
        ExternalAPIConfig configFromDB = Objects.requireNonNull(this.getExternalConfigFromDB());
        if (payload.getEnabled() != null) {
            configFromDB.setEnabled(payload.getEnabled());
        }
        if (!payload.getEnabled().booleanValue()) {
            configFromDB.save();
            return configFromDB;
        }
        if (payload.getUrl() != null) {
            configFromDB.setUrl(payload.getUrl());
        }
        if (payload.getAuthHeader() != null) {
            configFromDB.setAuthHeader(payload.getAuthHeader().name());
        }
        KeyPair keyPair = this.globalKeyPairService.getKeyPair();
        String username = this.shouldUpdateUsername(payload.getAuthHeader()) ? payload.getUsername() : null;
        String[] encrypted = this.globalKeyPairService.encryptUsernameAndToken(keyPair, username, payload.getToken());
        if (payload.getUsername() != null && !payload.getUsername().isEmpty() && this.shouldUpdateUsername(payload.getAuthHeader())) {
            configFromDB.setUsername(encrypted[0]);
        } else if (payload.getAuthHeader().equals((Object)AuthHeader.BEARER)) {
            configFromDB.setUsername(null);
        }
        if (payload.getToken() != null && !payload.getToken().isEmpty()) {
            configFromDB.setToken(encrypted[1]);
        }
        configFromDB.save();
        return configFromDB;
    }

    private ExternalAPIConfig getExternalConfigFromDB() {
        ExternalAPIConfig[] configList = (ExternalAPIConfig[])this.activeObjects.find(ExternalAPIConfig.class);
        if (configList.length == 0) {
            return null;
        }
        return configList[0];
    }

    private ExternalAPIConfigJson toExternalAPIConfigJson(ExternalAPIConfig config, KeyPair keyPair) throws GeneralSecurityException {
        if (config == null) {
            return null;
        }
        String username = this.globalKeyPairService.decryptString(keyPair, config.getUsername());
        String token = this.globalKeyPairService.decryptString(keyPair, config.getToken());
        return new ExternalAPIConfigJson(config.isEnabled(), config.getUrl(), AuthHeader.valueOf(config.getAuthHeader()), username, token);
    }

    private ExternalAPIConfigReadOnly toExternalAPIConfigReadOnly(ExternalAPIConfig config) {
        if (config == null) {
            return null;
        }
        return new ExternalAPIConfigReadOnly(config.isEnabled(), config.getUrl(), AuthHeader.valueOf(config.getAuthHeader()));
    }
}

