/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task;

import co.uk.automationconsultants.compliance.exception.task.NoSuchTaskException;
import co.uk.automationconsultants.compliance.exception.task.TaskExecutionException;
import co.uk.automationconsultants.compliance.json.task.LogLevelEnum;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.utils.task.TaskLogUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskRunnable
implements Callable<TaskStatusEnum>,
Supplier<TaskStatusEnum> {
    protected final TaskDBService taskDBService;
    protected final int taskId;
    private final String paramsJson;
    private final ConfluenceUser actingUser;
    private boolean cancelled = false;
    @ComponentImport
    protected final TransactionTemplate transactionTemplate;
    private static final Logger logger = LoggerFactory.getLogger(TaskRunnable.class);

    protected TaskRunnable(TaskDBService taskDBService, int taskId, String paramsJson, ConfluenceUser actingUser, TransactionTemplate transactionTemplate) {
        this.taskDBService = taskDBService;
        this.taskId = taskId;
        this.paramsJson = paramsJson;
        this.actingUser = actingUser;
        this.transactionTemplate = transactionTemplate;
    }

    public abstract void execute() throws InterruptedException, TaskExecutionException;

    @Override
    public TaskStatusEnum call() {
        return this.runTask();
    }

    @Override
    public TaskStatusEnum get() {
        return this.runTask();
    }

    public TaskStatusEnum runTask() {
        if (this.cancelled) {
            return TaskStatusEnum.CANCELLED;
        }
        AuthenticatedUserThreadLocal.set((ConfluenceUser)this.actingUser);
        this.initialiseTask();
        try {
            this.execute();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            return this.failTask(e.getMessage());
        }
        return this.finishTask();
    }

    private void initialiseTask() {
        this.transactionTemplate.execute(() -> {
            TaskJson payload = TaskJson.builder().id(this.taskId).status(TaskStatusEnum.IN_PROGRESS).timeStarted(new Date()).build();
            try {
                this.taskDBService.updateTask(payload);
            }
            catch (NoSuchTaskException e) {
                try {
                    Thread.sleep(5000L);
                    this.taskDBService.updateTask(payload);
                }
                catch (InterruptedException err) {
                    Thread.currentThread().interrupt();
                }
                catch (NoSuchTaskException ex) {
                    logger.error("Task {} could not be found when trying to initialise task for execution", (Object)this.taskId);
                }
            }
            return null;
        });
    }

    private TaskStatusEnum failTask(String errMessage) {
        this.addErrorLog(errMessage);
        return (TaskStatusEnum)((Object)this.transactionTemplate.execute(() -> {
            TaskJson payload = TaskJson.builder().id(this.taskId).status(TaskStatusEnum.FAILED).timeEnded(new Date()).build();
            try {
                this.taskDBService.updateTask(payload);
            }
            catch (NoSuchTaskException e) {
                e.printStackTrace();
            }
            return TaskStatusEnum.FAILED;
        }));
    }

    private TaskStatusEnum finishTask() {
        return (TaskStatusEnum)((Object)this.transactionTemplate.execute(() -> {
            TaskJson task = this.taskDBService.getTask(this.taskId);
            TaskStatusEnum statusEnum = this.cancelled ? TaskStatusEnum.CANCELLED : (task.getSuccess() == task.getTotalCount() ? TaskStatusEnum.SUCCESS : (task.getSuccess() == 0 ? TaskStatusEnum.FAILED : TaskStatusEnum.SUCCESS_WITH_ERRORS));
            TaskJson payload = TaskJson.builder().id(this.taskId).timeEnded(new Date()).status(statusEnum).build();
            try {
                this.taskDBService.updateTask(payload);
            }
            catch (NoSuchTaskException e) {
                logger.error("Task {} could not be found when trying to finish task execution", (Object)this.taskId);
            }
            return statusEnum;
        }));
    }

    protected void addTaskLog(LogLevelEnum logLevelEnum, String message, Long pageId, Long spaceId, String spaceKey) {
        this.transactionTemplate.execute(() -> {
            this.taskDBService.addTaskLog(this.taskId, logLevelEnum, message, pageId, spaceId, spaceKey);
            return null;
        });
        TaskLogUtils.addTaskLogForLogger(logger, logLevelEnum, String.format("%s, for page ID %d, in space %s", message, pageId, spaceKey));
    }

    protected void addTaskLog(LogLevelEnum logLevelEnum, String message) {
        this.transactionTemplate.execute(() -> {
            this.taskDBService.addTaskLog(this.taskId, logLevelEnum, message);
            return null;
        });
        TaskLogUtils.addTaskLogForLogger(logger, logLevelEnum, message);
    }

    protected void addErrorLog(String message) {
        this.addTaskLog(LogLevelEnum.ERROR, message, null, null, null);
    }

    public void cancel() {
        this.cancelled = true;
        this.transactionTemplate.execute(() -> {
            this.taskDBService.cancelTask(this.taskId);
            return null;
        });
    }

    public void kill() {
        this.cancelled = true;
        this.transactionTemplate.execute(() -> {
            this.taskDBService.killTask(this.taskId);
            return null;
        });
        Thread.currentThread().interrupt();
    }

    public boolean isCancelled() {
        TaskStatusEnum taskStatus = (TaskStatusEnum)((Object)this.transactionTemplate.execute(() -> {
            TaskJson taskJson = this.taskDBService.getTask(this.taskId);
            return taskJson.getStatus();
        }));
        return Thread.currentThread().isInterrupted() || this.cancelled && taskStatus.equals((Object)TaskStatusEnum.CANCELLED);
    }

    protected void updateTotalCount(int totalCount) {
        this.transactionTemplate.execute(() -> {
            this.taskDBService.updateTotalCount(this.taskId, totalCount);
            return null;
        });
    }

    protected TaskDBService getTaskService() {
        return this.taskDBService;
    }

    protected int getTaskId() {
        return this.taskId;
    }

    protected String getParamsJson() {
        return this.paramsJson;
    }

    protected ConfluenceUser getActingUser() {
        return this.actingUser;
    }

    protected TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }
}

