/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.entity.analysis.ExtractionResult;
import co.uk.automationconsultants.compliance.entity.extractions.ExtractionEntity;
import co.uk.automationconsultants.compliance.json.analysis.AnalysisResultJson;
import co.uk.automationconsultants.compliance.json.analysis.SearchResultJson;
import co.uk.automationconsultants.compliance.json.analysis.search.SensitiveDataSortKey;
import co.uk.automationconsultants.compliance.json.analysis.search.SortOrder;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

@Named(value="sensitiveSearchService")
public class SensitiveSearchService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final SystemInformationService systemInformationService;

    @Inject
    public SensitiveSearchService(ActiveObjects activeObjects, SpaceManager spaceManager, PageManager pageManager, SystemInformationService systemInformationService) {
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.systemInformationService = systemInformationService;
    }

    public SearchResultJson searchSensitiveData(List<String> spaceKeys, List<Long> extractionTypes, int startAt, int limit, String query, SensitiveDataSortKey sortKey, SortOrder sortOrder) {
        String extractions = null;
        if (!extractionTypes.isEmpty()) {
            extractions = StringEscapeUtils.escapeSql((String)StringUtils.join(extractionTypes, (String)","));
        }
        String passedQuery = null;
        if (query != null) {
            query = StringEscapeUtils.escapeSql((String)query);
            passedQuery = "%" + query.toLowerCase() + "%";
        }
        String spaces = null;
        if (!spaceKeys.isEmpty()) {
            List spaceIds = spaceKeys.stream().filter(s -> this.spaceManager.getSpace(s) != null).map(s -> String.valueOf(Objects.requireNonNull(this.spaceManager.getSpace(s)).getId())).collect(Collectors.toList());
            spaces = StringEscapeUtils.escapeSql((String)StringUtils.join(spaceIds, (String)","));
        }
        Query countQuery = Query.select();
        countQuery.setWhereClause(this.parseSQLForDBType(this.generateCountWhereClause(extractions, passedQuery, spaces)));
        countQuery.setWhereParams(this.generateCountWhereParams(query));
        int count = this.activeObjects.count(ExtractionResult.class, countQuery);
        Query mainQuery = Query.select().alias(ExtractionResult.class, "EXTRACTION_RESULT").alias(ExtractionEntity.class, "EXTRACTIONS");
        if (sortKey == SensitiveDataSortKey.TYPE) {
            mainQuery = mainQuery.join(ExtractionEntity.class, "EXTRACTIONS.ID = EXTRACTION_RESULT.EXTRACTION_ENTITY_ID");
        }
        mainQuery.setOrderClause(this.parseSQLForDBType(this.generateOrderClause(sortKey, sortOrder)));
        mainQuery.setWhereClause(this.parseSQLForDBType(this.generateWhereClause(spaces, extractions, query)));
        mainQuery.setWhereParams(this.generateWhereParams(query));
        mainQuery.setOffset(startAt);
        mainQuery.setLimit(limit);
        List<AnalysisResultJson> results = Arrays.stream((ExtractionResult[])this.activeObjects.find(ExtractionResult.class, mainQuery)).map(extractionResult -> AnalysisResultJson.map(this.spaceManager, this.pageManager, extractionResult)).collect(Collectors.toList());
        return new SearchResultJson(results, startAt, limit, count);
    }

    public String parseSQLForDBType(String sqlQuery) {
        String dialect = this.systemInformationService.getDatabaseInfo().getDialect();
        if (dialect.contains("MySQL")) {
            return sqlQuery.replace('\"', '`');
        }
        return sqlQuery;
    }

    private Object[] generateCountWhereParams(String query) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(true);
        if (query != null) {
            params.add("%" + StringEscapeUtils.escapeSql((String)query).toLowerCase() + "%");
        }
        return params.toArray();
    }

    private String generateCountWhereClause(String extractions, String query, String spaces) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"ACTIVE\" = ? AND \"STATUS\" IS NULL");
        if (extractions != null) {
            stringBuilder.append(" AND \"EXTRACTION_ENTITY_ID\" IN (").append(extractions).append(")");
        }
        if (query != null) {
            stringBuilder.append(" AND LOWER(\"CAPTURED_TEXT\") LIKE ?");
        }
        if (spaces != null) {
            stringBuilder.append(" AND \"SPACE_ID\" IN (").append(spaces).append(")");
        }
        return stringBuilder.toString();
    }

    private Object[] generateWhereParams(String query) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(true);
        if (query != null) {
            params.add("%" + query.replace("'", "''").toLowerCase() + "%");
        }
        return params.toArray();
    }

    private String generateWhereClause(String spaces, String extractions, String query) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"ACTIVE\" = ? AND \"STATUS\" IS NULL");
        if (spaces != null) {
            stringBuilder.append(" AND \"SPACE_ID\" IN (").append(spaces).append(")");
        }
        if (extractions != null) {
            stringBuilder.append(" AND \"EXTRACTION_ENTITY_ID\" IN (").append(extractions).append(")");
        }
        if (query != null) {
            stringBuilder.append(" AND LOWER(\"CAPTURED_TEXT\") LIKE ?");
        }
        return stringBuilder.toString();
    }

    private String generateOrderClause(SensitiveDataSortKey sortKey, SortOrder sortOrder) {
        if (sortKey == null || sortOrder == null) {
            return "\"DETECTION_DATE\" DESC";
        }
        switch (sortKey) {
            case TYPE: {
                return "\"NAME\" " + sortOrder.name() + ", \"DETECTION_DATE\" DESC";
            }
            case TEXT: {
                return "\"CAPTURED_TEXT\"" + sortOrder.name() + ", \"DETECTION_DATE\" DESC";
            }
            case DETECTED: {
                return "\"DETECTION_DATE\" " + sortOrder.name();
            }
        }
        return "\"DETECTION_DATE\" DESC";
    }
}

