/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.json.request.DraftRequestJson;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/drafts")
public class DraftRest {
    @ComponentImport
    private final LabelManager labelManager;
    @ComponentImport
    private final DraftsTransitionHelper draftsTransitionHelper;

    @Inject
    public DraftRest(LabelManager labelManager, DraftsTransitionHelper draftsTransitionHelper) {
        this.labelManager = labelManager;
        this.draftsTransitionHelper = draftsTransitionHelper;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addDraft(@Context HttpServletRequest request, DraftRequestJson draftRequestJson) {
        long draftId = draftRequestJson.getDraftId();
        int levelId = draftRequestJson.getLevel();
        ContentEntityObject draft = this.draftsTransitionHelper.getDraft(draftId);
        if (draft != null) {
            for (Label label : draft.getLabels()) {
                if (!label.getName().contains("classification-")) continue;
                this.labelManager.removeLabel((Labelable)draft, label);
            }
            Label label = this.labelManager.getLabel(String.format("classification-%d", levelId));
            if (label == null) {
                label = this.labelManager.createLabel(new Label(String.format("classification-%d", levelId)));
            }
            this.labelManager.addLabel((Labelable)draft, label);
            return Response.ok().build();
        }
        return Response.status((int)400).build();
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getDraft(@Context HttpServletRequest request, @QueryParam(value="shareId") long draftId) {
        ContentEntityObject draft = this.draftsTransitionHelper.getDraft(draftId);
        if (draft != null) {
            for (Label label : draft.getLabels()) {
                if (!label.getName().contains("classification-")) continue;
                String classificationIdString = label.getName().replace("classification-", "");
                int classificationIdInt = Integer.parseInt(classificationIdString);
                return Response.ok((Object)new DraftRequestJson(draftId, classificationIdInt)).build();
            }
        }
        return Response.status((int)404).build();
    }
}

