/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.cache.GlobalSettingsCache;
import co.uk.automationconsultants.compliance.entity.ClassificationLevel;
import co.uk.automationconsultants.compliance.entity.SettingEntity;
import co.uk.automationconsultants.compliance.entity.SpaceSettingEntity;
import co.uk.automationconsultants.compliance.helper.SpaceHelper;
import co.uk.automationconsultants.compliance.impl.SortByPrimaryKey;
import co.uk.automationconsultants.compliance.json.level.LevelJson;
import co.uk.automationconsultants.compliance.json.level.LevelRestrictionJson;
import co.uk.automationconsultants.compliance.json.level.LevelUsageJson;
import co.uk.automationconsultants.compliance.json.level.LevelsJson;
import co.uk.automationconsultants.compliance.service.settings.SettingsService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/level")
public class LevelRest {
    private static final String HIGHLY_RESTRICTED_DESCRIPTION = "Information presents the greatest danger if it were lost or disclosed. Only very limited audiences (sometimes just a single person) have access to this information.";
    private static final String RESTRICTED_DESCRIPTION = "Only people with a need to know should see Restricted information. Its loss or disclosure would pose a moderate to major risk.";
    private static final String INTERNAL_DESCRIPTION = "Commonly available to all employees. Internal information would pose only a minor risk if the information was lost or disclosed.";
    private static final String PUBLIC_DESCRIPTION = "Lowest level of security, data is freely available to the public and employees. Public information requires no special protection.";
    private static final String SETTING_ENTITY_ID = "SETTING_ENTITY_ID";
    private static final String NAME = "NAME";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String COLOUR = "COLOUR";
    private static final Logger log = LoggerFactory.getLogger(LevelRest.class);
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final SettingsService settingsService;
    private final GlobalSettingsCache globalSettingsCache;
    private final SpaceHelper spaceHelper;

    @Inject
    public LevelRest(ActiveObjects activeObjects, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, SettingsService settingsService, GlobalSettingsCache globalSettingsCache, SpaceHelper spaceHelper) {
        this.activeObjects = activeObjects;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.settingsService = settingsService;
        this.globalSettingsCache = globalSettingsCache;
        this.spaceHelper = spaceHelper;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getLevels(@Context HttpServletRequest request) {
        return Response.ok((Object)this.globalSettingsCache.getGlobalSettings(), (String)"application/json").build();
    }

    @PUT
    @WebSudoRequired
    @Produces(value={"application/json"})
    public Response createLevel(@Context HttpServletRequest request, LevelJson levelJson) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SettingEntity[] settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class);
        Arrays.sort(settingEntities, new SortByPrimaryKey());
        SettingEntity settingEntity = settingEntities[settingEntities.length - 1];
        this.activeObjects.executeInTransaction(() -> {
            this.activeObjects.create(ClassificationLevel.class, new DBParam[]{new DBParam(SETTING_ENTITY_ID, (Object)settingEntity.getID()), new DBParam(NAME, (Object)levelJson.getName()), new DBParam(DESCRIPTION, (Object)levelJson.getDescription()), new DBParam(COLOUR, (Object)levelJson.getColour())});
            return true;
        });
        List<LevelRestrictionJson> restrictions = this.settingsService.getRestrictions();
        if (restrictions != null) {
            restrictions.add(new LevelRestrictionJson(levelJson.getName(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>()));
            this.settingsService.setRestrictions(restrictions);
        }
        this.globalSettingsCache.invalidateCaches();
        return this.getLevels(request);
    }

    @POST
    @WebSudoRequired
    @Produces(value={"application/json"})
    public Response updateLevel(@Context HttpServletRequest request, LevelJson levelJson, @QueryParam(value="index") int index) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SettingEntity[] settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class);
        Arrays.sort(settingEntities, new SortByPrimaryKey());
        SettingEntity settingEntity = settingEntities[settingEntities.length - 1];
        ClassificationLevel[] classificationLevels = settingEntity.getClassificationLevels();
        Arrays.sort(classificationLevels, new SortByPrimaryKey());
        List<ClassificationLevel> classificationLevelsArray = Arrays.asList(classificationLevels);
        ClassificationLevel classificationLevel = classificationLevelsArray.get(index);
        if (classificationLevel != null) {
            this.activeObjects.executeInTransaction(() -> {
                classificationLevel.setSettingEntity(settingEntity);
                classificationLevel.setName(levelJson.getName());
                classificationLevel.setDescription(levelJson.getDescription());
                classificationLevel.setColour(levelJson.getColour());
                classificationLevel.save();
                return true;
            });
            List<LevelRestrictionJson> restrictions = this.settingsService.getRestrictions();
            if (restrictions != null) {
                restrictions.get(index).setName(levelJson.getName());
                this.settingsService.setRestrictions(restrictions);
            }
            this.globalSettingsCache.invalidateCaches();
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @DELETE
    @WebSudoRequired
    @Produces(value={"application/json"})
    public Response deleteLevel(@Context HttpServletRequest request, @QueryParam(value="index") int index) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SettingEntity[] settingEntities = (SettingEntity[])this.activeObjects.find(SettingEntity.class);
        Arrays.sort(settingEntities, new SortByPrimaryKey());
        SettingEntity settingEntity = settingEntities[settingEntities.length - 1];
        ClassificationLevel[] classificationLevels = settingEntity.getClassificationLevels();
        Arrays.sort(classificationLevels, new SortByPrimaryKey());
        List<ClassificationLevel> classificationLevelsArray = Arrays.asList(classificationLevels);
        ClassificationLevel classificationLevel = classificationLevelsArray.get(index);
        if (classificationLevel != null) {
            this.activeObjects.executeInTransaction(() -> {
                SpaceSettingEntity[] spaceSettingEntities;
                if (index == settingEntity.getGlobalDefaultLevel()) {
                    settingEntity.setGlobalDefaultLevel(-1);
                    settingEntity.save();
                }
                for (SpaceSettingEntity spaceSetting : spaceSettingEntities = (SpaceSettingEntity[])this.activeObjects.find(SpaceSettingEntity.class, "SPACE_DEFAULT_LEVEL_ID = ?", new Object[]{classificationLevel.getID()})) {
                    spaceSetting.setSpaceDefaultLevel(null);
                    spaceSetting.save();
                }
                this.activeObjects.delete(new RawEntity[]{classificationLevel});
                return true;
            });
            List<LevelRestrictionJson> restrictions = this.settingsService.getRestrictions();
            if (restrictions != null) {
                restrictions.remove(index);
                this.settingsService.setRestrictions(restrictions);
            }
            this.globalSettingsCache.invalidateCaches();
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @WebSudoRequired
    @Produces(value={"application/json"})
    @Path(value="/usage")
    public Response getLevelUsage(@Context HttpServletRequest request, @QueryParam(value="index") Integer index) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
        if (settings.length == 0) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        if (settings[0].getManageDefaultLevelGlobally().booleanValue() && Objects.equals(settings[0].getGlobalDefaultLevel(), index)) {
            return Response.ok((Object)new LevelUsageJson(true), (String)"application/json").build();
        }
        ClassificationLevel classificationLevel = ((ClassificationLevel[])this.activeObjects.find(ClassificationLevel.class))[index];
        int numSpacesUsingLevel = this.activeObjects.count(SpaceSettingEntity.class, Query.select().where("SPACE_DEFAULT_LEVEL_ID = ?", new Object[]{classificationLevel.getID()}));
        SpaceSettingEntity[] spaceSettingEntities = (SpaceSettingEntity[])this.activeObjects.find(SpaceSettingEntity.class, Query.select().where("SPACE_DEFAULT_LEVEL_ID = ?", new Object[]{classificationLevel.getID()}).limit(50));
        if (!settings[0].getManageDefaultLevelGlobally().booleanValue() && spaceSettingEntities.length > 0) {
            ArrayList<String> spaceNamesAndKeys = new ArrayList<String>();
            for (SpaceSettingEntity spaceSetting : spaceSettingEntities) {
                String spaceKey = spaceSetting.getSpaceKey();
                spaceNamesAndKeys.add(this.spaceHelper.getSpaceByKey(spaceKey).getName() + " (" + spaceKey + ")");
            }
            return Response.ok((Object)new LevelUsageJson(true, spaceNamesAndKeys, numSpacesUsingLevel), (String)"application/json").build();
        }
        return Response.ok((Object)new LevelUsageJson(false)).build();
    }

    @PUT
    @WebSudoRequired
    @Produces(value={"application/json"})
    @Path(value="/default")
    public Response updateGlobalDefaultLevel(@Context HttpServletRequest request, @QueryParam(value="manageGlobally") Boolean manageGlobally, @QueryParam(value="levelId") Integer levelId) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (manageGlobally == null || levelId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
        if (settings.length == 0) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        this.activeObjects.executeInTransaction(() -> {
            settings[0].setManageDefaultLevelGlobally(manageGlobally);
            settings[0].setGlobalDefaultLevel(levelId);
            settings[0].save();
            this.globalSettingsCache.invalidateCaches();
            return settings[0];
        });
        return Response.ok().build();
    }

    public static LevelsJson getLevels(ActiveObjects activeObjects) {
        SettingEntity[] settingEntities = (SettingEntity[])activeObjects.find(SettingEntity.class);
        List<LevelJson> levels = new ArrayList<LevelJson>();
        LevelsJson output = new LevelsJson();
        if (settingEntities.length > 0) {
            Arrays.sort(settingEntities, new SortByPrimaryKey());
            SettingEntity settingEntity = settingEntities[settingEntities.length - 1];
            ClassificationLevel[] classificationLevels = settingEntity.getClassificationLevels();
            Arrays.sort(classificationLevels, new SortByPrimaryKey());
            levels = Arrays.stream(classificationLevels).map(classificationLevel -> new LevelJson(classificationLevel.getName(), classificationLevel.getDescription(), classificationLevel.getColour())).collect(Collectors.toCollection(ArrayList::new));
            output.setDataByline(settingEntity.getDataByline() != null ? settingEntity.getDataByline() : Boolean.valueOf(true));
            output.setManageDefaultLevelGlobally(settingEntity.getManageDefaultLevelGlobally() != null ? settingEntity.getManageDefaultLevelGlobally() : false);
            output.setGlobalDefaultLevel(settingEntity.getGlobalDefaultLevel() != null ? settingEntity.getGlobalDefaultLevel() : -1);
            output.setForce(settingEntity.getForce() != null ? settingEntity.getForce() : Boolean.valueOf(false));
            output.setMacroSize(settingEntity.getMacroSize() != null ? settingEntity.getMacroSize() : "medium");
            output.setPrintOnly(settingEntity.getPrintOnly() != null ? settingEntity.getPrintOnly() : true);
            output.setMacroPrefix(settingEntity.getMacroPreface() != null ? settingEntity.getMacroPreface() : "");
            output.setSpaceLevel(settingEntity.getSpaceLevel() != null ? settingEntity.getSpaceLevel() : Boolean.valueOf(true));
            output.setSpaceData(settingEntity.getSpaceData() != null ? settingEntity.getSpaceData() : Boolean.valueOf(true));
        } else {
            LevelRest.createEntities(activeObjects);
            levels.add(new LevelJson("Highly Restricted", HIGHLY_RESTRICTED_DESCRIPTION, "dark-red"));
            levels.add(new LevelJson("Restricted", RESTRICTED_DESCRIPTION, "orange"));
            levels.add(new LevelJson("Internal", INTERNAL_DESCRIPTION, "blue"));
            levels.add(new LevelJson("Public", PUBLIC_DESCRIPTION, "green"));
            output.setDataByline(true);
            output.setManageDefaultLevelGlobally(false);
            output.setGlobalDefaultLevel(-1);
            output.setForce(false);
            output.setMacroSize("medium");
            output.setPrintOnly(true);
            output.setMacroPrefix("");
            output.setSpaceData(true);
            output.setSpaceLevel(true);
        }
        output.setLevels(levels);
        return output;
    }

    private static void createEntities(ActiveObjects activeObjects) {
        activeObjects.executeInTransaction(() -> {
            SettingEntity settingEntity = (SettingEntity)activeObjects.create(SettingEntity.class, new DBParam[0]);
            activeObjects.create(ClassificationLevel.class, new DBParam[]{new DBParam(SETTING_ENTITY_ID, (Object)settingEntity.getID()), new DBParam(NAME, (Object)"Highly Restricted"), new DBParam(DESCRIPTION, (Object)HIGHLY_RESTRICTED_DESCRIPTION), new DBParam(COLOUR, (Object)"dark-red")});
            activeObjects.create(ClassificationLevel.class, new DBParam[]{new DBParam(SETTING_ENTITY_ID, (Object)settingEntity.getID()), new DBParam(NAME, (Object)"Restricted"), new DBParam(DESCRIPTION, (Object)RESTRICTED_DESCRIPTION), new DBParam(COLOUR, (Object)"orange")});
            activeObjects.create(ClassificationLevel.class, new DBParam[]{new DBParam(SETTING_ENTITY_ID, (Object)settingEntity.getID()), new DBParam(NAME, (Object)"Internal"), new DBParam(DESCRIPTION, (Object)INTERNAL_DESCRIPTION), new DBParam(COLOUR, (Object)"blue")});
            activeObjects.create(ClassificationLevel.class, new DBParam[]{new DBParam(SETTING_ENTITY_ID, (Object)settingEntity.getID()), new DBParam(NAME, (Object)"Public"), new DBParam(DESCRIPTION, (Object)PUBLIC_DESCRIPTION), new DBParam(COLOUR, (Object)"green")});
            return settingEntity;
        });
    }
}

