/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.entity.AOUpgradeTask;

import co.uk.automationconsultants.compliance.entity.ClassificationLevel;
import co.uk.automationconsultants.compliance.entity.SettingEntity;
import co.uk.automationconsultants.compliance.impl.SortByPrimaryKey;
import co.uk.automationconsultants.compliance.json.level.LevelRestrictionJson;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncRestrictionsUpgradeTask
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(SyncRestrictionsUpgradeTask.class);

    private boolean areSynced(ClassificationLevel[] levels, List<LevelRestrictionJson> restrictions) {
        if (levels.length != restrictions.size()) {
            return false;
        }
        for (int i = 0; i < levels.length; ++i) {
            if (Objects.equals(levels[i].getName(), restrictions.get(i).getName())) continue;
            return false;
        }
        return true;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"3");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        int i;
        List restrictions;
        activeObjects.migrate(new Class[]{SettingEntity.class, ClassificationLevel.class});
        SettingEntity[] settingEntities = (SettingEntity[])activeObjects.find(SettingEntity.class);
        if (settingEntities.length == 0) {
            log.debug("SyncRestrictionsUpgradeTask: No Settings row yet present - nothing to do");
            return;
        }
        Arrays.sort(settingEntities, new SortByPrimaryKey());
        SettingEntity settingEntity = settingEntities[settingEntities.length - 1];
        if (settingEntity == null) {
            log.debug("SyncRestrictionsUpgradeTask: Settings row was null - nothing to do");
            return;
        }
        String restrictionsStr = settingEntity.getRestrictions();
        if (restrictionsStr == null) {
            log.debug("SyncRestrictionsUpgradeTask: Restrictions field hasn't been set yet - it is null. Nothing to do");
            return;
        }
        ClassificationLevel[] classificationLevels = (ClassificationLevel[])activeObjects.find(ClassificationLevel.class);
        if (classificationLevels.length == 0) {
            log.debug("SyncRestrictionsUpgradeTask: No classification levels present in CLEVEL table - aborting upgrade task");
            return;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            restrictions = (List)objectMapper.readValue(restrictionsStr, (TypeReference)new TypeReference<List<LevelRestrictionJson>>(){});
        }
        catch (IOException e) {
            log.error("SyncRestrictionsUpgradeTask Failed: Could not deserialize RESTRICTIONS field JSON");
            return;
        }
        boolean synced = this.areSynced(classificationLevels, restrictions);
        if (synced) {
            log.debug("SyncRestrictionsUpgradeTask: CLEVEL table and RESTRICTIONS field already synced, no need to upgrade!");
            return;
        }
        log.debug("SyncRestrictionsUpgradeTask: CLEVEL table and RESTRICTIONS field not synced, performing upgrade task...");
        ArrayList<LevelRestrictionJson> newRestrictions = new ArrayList<LevelRestrictionJson>();
        for (i = 0; i < classificationLevels.length; ++i) {
            LevelRestrictionJson restriction;
            if (i < restrictions.size()) {
                restriction = new LevelRestrictionJson(classificationLevels[i].getName(), ((LevelRestrictionJson)restrictions.get(i)).getusers(), ((LevelRestrictionJson)restrictions.get(i)).getGroups(), ((LevelRestrictionJson)restrictions.get(i)).getRoles());
                newRestrictions.add(restriction);
                continue;
            }
            restriction = new LevelRestrictionJson(classificationLevels[i].getName(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>());
            newRestrictions.add(restriction);
        }
        for (i = 0; i < newRestrictions.size(); ++i) {
            if (i < restrictions.size()) {
                boolean usersSame = ((LevelRestrictionJson)newRestrictions.get(i)).getusers().equals(((LevelRestrictionJson)restrictions.get(i)).getusers());
                boolean groupsSame = ((LevelRestrictionJson)newRestrictions.get(i)).getGroups().equals(((LevelRestrictionJson)restrictions.get(i)).getGroups());
                boolean rolesSame = ((LevelRestrictionJson)newRestrictions.get(i)).getRoles().equals(((LevelRestrictionJson)restrictions.get(i)).getRoles());
                if (usersSame && groupsSame && rolesSame) continue;
                log.error("SyncRestrictionsUpgradeTask: Existing restrictions not migrated properly. Upgrade task halted");
                return;
            }
            boolean usersEmpty = ((LevelRestrictionJson)newRestrictions.get(i)).getusers().isEmpty();
            boolean groupsEmpty = ((LevelRestrictionJson)newRestrictions.get(i)).getGroups().isEmpty();
            boolean rolesEmpty = ((LevelRestrictionJson)newRestrictions.get(i)).getRoles().isEmpty();
            if (usersEmpty && groupsEmpty && rolesEmpty) continue;
            log.error("SyncRestrictionsUpgradeTask: Newly created restrictions that should be empty, aren't empty. Upgrade task halted");
            return;
        }
        log.debug("SyncRestrictionsUpgradeTask: Restrictions synced, writing to RESTRICTIONS field...");
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String newRestrictionsStr = objectMapper.writeValueAsString(newRestrictions);
            settingEntity.setRestrictions(newRestrictionsStr);
            settingEntity.save();
        }
        catch (IOException e) {
            log.error("SyncRestrictionsUpgradeTask Failed: Could not serialise new RESTRICTIONS to string");
        }
        log.debug("SyncRestrictionsUpgradeTask: Successfully wrote new restrictions to DB!");
    }
}

