/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.macro;

import co.uk.automationconsultants.compliance.cache.GlobalSettingsCache;
import co.uk.automationconsultants.compliance.json.level.LevelJson;
import co.uk.automationconsultants.compliance.json.level.LevelsJson;
import co.uk.automationconsultants.compliance.service.ClassificationService;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class LevelMacro
extends BaseMacro
implements Macro {
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final ContentPropertyService contentPropertyService;
    @ComponentImport
    private final VelocityHelperService velocityHelperService;
    private final GlobalSettingsCache globalSettingsCache;
    private final ClassificationService classificationService;

    @Inject
    public LevelMacro(PageManager pageManager, ClassificationService classificationService, ContentPropertyService contentPropertyService, VelocityHelperService velocityHelperService, GlobalSettingsCache globalSettingsCache) {
        this.pageManager = pageManager;
        this.classificationService = classificationService;
        this.contentPropertyService = contentPropertyService;
        this.velocityHelperService = velocityHelperService;
        this.globalSettingsCache = globalSettingsCache;
    }

    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) {
        try {
            ConfluenceUser user;
            LevelsJson settings;
            block7: {
                settings = this.globalSettingsCache.getGlobalSettings();
                user = AuthenticatedUserThreadLocal.get();
                ContentId contentId = Objects.requireNonNull(conversionContext.getEntity()).getContentId();
                contentId = Objects.requireNonNull(this.pageManager.getPage(contentId.asLong())).getLatestVersion().getContentId();
                JsonContentProperty existingLevel = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(contentId).withPropertyKey("classification").fetchOneOrNull();
                if (existingLevel != null) {
                    try {
                        JsonElement parsed = new JsonParser().parse(existingLevel.getValue().getValue());
                        JsonObject rootJson = parsed.getAsJsonObject();
                        JsonObject nameJson = rootJson.get("name").getAsJsonObject();
                        int level = nameJson.get("index").getAsInt();
                        List<LevelJson> levels = this.classificationService.getLevels();
                        if (level >= levels.size()) {
                            map.put("type", "2");
                            map.put("name", "Unknown Classification");
                            break block7;
                        }
                        map.put("name", levels.get(level).getName());
                        map.put("type", "1");
                        map.put("color", levels.get(level).getColour());
                    }
                    catch (ServiceException serviceException) {}
                } else {
                    map.put("name", "Pending Classification");
                    map.put("type", "0");
                }
            }
            map.put("prefix", settings.getMacroPrefix());
            map.put("size", settings.getMacroSize());
            return this.getServerRendered(user, this.getPageId(conversionContext), this.getPageVersion(conversionContext), new HashMap<String, Object>(map), !conversionContext.getOutputType().equals("display") || settings.getPrintOnly() == false);
        }
        catch (Exception e) {
            map.put("error", e.getMessage());
            return this.velocityHelperService.getRenderedTemplate("/templates/display/macro/error.vm", new HashMap<String, String>(map));
        }
    }

    private int getLatestVersion(ConversionContext conversionContext) {
        ContentEntityObject entity = conversionContext.getEntity();
        if (entity != null) {
            return entity.getLatestVersion().getVersion();
        }
        return -1;
    }

    private String getServerRendered(ConfluenceUser user, long pageId, int pageVersion, Map<String, Object> map, boolean print) {
        if (print) {
            return this.velocityHelperService.getRenderedTemplate("/templates/display/macro/print.vm", map);
        }
        return this.velocityHelperService.getRenderedTemplate("/templates/display/macro/error.vm", map);
    }

    private long getPageId(ConversionContext context) throws NullPointerException {
        return Objects.requireNonNull(context.getEntity()).getLatestVersionId();
    }

    private int getPageVersion(ConversionContext context) throws NullPointerException {
        return Objects.requireNonNull(context.getEntity()).getVersion();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map map, String s, RenderContext renderContext) throws MacroException {
        try {
            ContentEntityObject entity;
            ConfluenceUser user;
            LevelsJson settings;
            block7: {
                settings = this.globalSettingsCache.getGlobalSettings();
                user = AuthenticatedUserThreadLocal.get();
                entity = ((PageContext)renderContext).getEntity();
                ContentId contentId = Objects.requireNonNull(entity).getContentId();
                JsonContentProperty existingLevel = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(contentId).withPropertyKey("classification").fetchOneOrNull();
                if (existingLevel != null) {
                    try {
                        JsonElement parsed = new JsonParser().parse(existingLevel.getValue().getValue());
                        JsonObject rootJson = parsed.getAsJsonObject();
                        JsonObject nameJson = rootJson.get("name").getAsJsonObject();
                        int level = nameJson.get("index").getAsInt();
                        List<LevelJson> levels = this.classificationService.getLevels();
                        if (level >= levels.size()) {
                            map.put("type", "2");
                            map.put("name", "Unknown Classification");
                            break block7;
                        }
                        map.put("name", levels.get(level).getName());
                        map.put("type", "1");
                        map.put("color", levels.get(level).getColour());
                    }
                    catch (ServiceException serviceException) {}
                } else {
                    map.put("name", "Pending Classification");
                    map.put("type", "0");
                }
            }
            map.put("prefix", settings.getMacroPrefix());
            map.put("size", settings.getMacroSize());
            return this.getServerRendered(user, Objects.requireNonNull(entity).getLatestVersionId(), Objects.requireNonNull(entity).getVersion(), map, true);
        }
        catch (Exception e) {
            map.put("error", e.getMessage());
            return this.velocityHelperService.getRenderedTemplate("/templates/display/macro/error.vm", map);
        }
    }
}

