/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.listener;

import co.uk.automationconsultants.compliance.service.AnalysisService;
import co.uk.automationconsultants.compliance.service.maintenance.ContentPropertyMaintenanceService;
import co.uk.automationconsultants.compliance.service.maintenance.ExtractionResultMaintenanceService;
import com.atlassian.confluence.event.events.content.page.PageCopyEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named(value="analysisListener")
public class AnalysisListener
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AnalysisListener.class);
    @ComponentImport
    protected EventPublisher eventPublisher;
    private final AnalysisService analysisService;
    private final ExtractionResultMaintenanceService extractionResultMaintenanceService;
    private final ContentPropertyMaintenanceService contentPropertyMaintenanceService;

    @Inject
    public AnalysisListener(EventPublisher eventPublisher, AnalysisService analysisService, ExtractionResultMaintenanceService extractionResultMaintenanceService, ContentPropertyMaintenanceService contentPropertyMaintenanceService) {
        this.eventPublisher = eventPublisher;
        this.analysisService = analysisService;
        this.extractionResultMaintenanceService = extractionResultMaintenanceService;
        this.contentPropertyMaintenanceService = contentPropertyMaintenanceService;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void pageCreated(PageCreateEvent event) {
        log.debug(String.format("AnalysisListener PageCreateEvent: %s", event.getUpdateTrigger()));
        if (event.getUpdateTrigger() == PageUpdateTrigger.LINK_REFACTORING) {
            return;
        }
        this.contentPropertyMaintenanceService.deleteContentProperty("classificationanalysis", event.getPage());
        this.analysisService.processPageRealTime(event.getPage(), true);
    }

    @EventListener
    public void pageCopied(PageCopyEvent event) {
        log.debug(String.format("AnalysisListener PageCopyEvent: Copying page %s to page %s", event.getOrigin().getId(), event.getDestination().getId()));
        this.contentPropertyMaintenanceService.deleteContentProperty("classificationanalysis", event.getPage());
        this.analysisService.processPageRealTime(event.getPage(), true);
    }

    @EventListener
    public void pageRemoved(PageRemoveEvent event) {
        log.debug(String.format("AnalysisListener PageRemoveEvent: Removing page %s", event.getPage().getId()));
        this.analysisService.onDeletePage(event.getPage());
    }

    @EventListener
    public void pageTrashed(PageTrashedEvent event) {
        log.debug(String.format("AnalysisListener PageTrashedEvent: Trashing page %s", event.getPage().getId()));
        this.analysisService.onTrashPage(event.getPage());
    }

    @EventListener
    public void pageRestored(PageRestoreEvent event) {
        log.debug(String.format("AnalysisListener PageRestoreEvent: Restoring page %s", event.getPage().getId()));
        this.analysisService.onRestorePage(event.getPage());
    }

    @EventListener
    public void pageMoved(PageMoveEvent event) {
        if (event.isMovedSpace()) {
            Page page = event.getPage();
            log.debug(String.format("AnalysisListener PageMoveEvent: Moving page %s from space %s to space %s", page.getId(), event.getOldSpace().getId(), page.getSpace().getId()));
            this.extractionResultMaintenanceService.updateExtractionResultSpaceId(page, page.getSpace().getId());
            this.contentPropertyMaintenanceService.reAddComplianceContentProperties(page);
        }
    }

    @EventListener
    public void pageUpdated(PageUpdateEvent event) {
        log.debug(String.format("AnalysisListener PageUpdateEvent: %s", event.getUpdateTrigger()));
        this.analysisService.processPageRealTime(event.getPage(), true);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

