/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.utils.task;

import co.uk.automationconsultants.compliance.entity.task.Task;
import co.uk.automationconsultants.compliance.exception.task.NoSuchTaskException;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.json.task.TaskTypeEnum;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import com.atlassian.activeobjects.external.ActiveObjects;
import java.util.Date;
import javax.annotation.Nonnull;
import net.java.ao.DBParam;

public class TaskDBServiceUtils {
    public static final String NO_CLUSTER_IDENTIFIER = "NO_CLUSTER";

    private TaskDBServiceUtils() {
    }

    public static TaskJson createDefaultTask(ActiveObjects activeObjects, TaskTypeEnum taskTypeEnum, String paramsJson, String creator, String clusterIdentifier) {
        Date currentDate = new Date();
        Task task = (Task)activeObjects.create(Task.class, new DBParam[]{new DBParam("TIME_CREATED", (Object)currentDate), new DBParam("PARAMS_JSON", (Object)paramsJson), new DBParam("TASK_TYPE", (Object)taskTypeEnum.name()), new DBParam("TASK_STATUS", (Object)TaskStatusEnum.PENDING.name()), new DBParam("CREATOR", (Object)creator), new DBParam("MANAGER_NODE", (Object)clusterIdentifier), new DBParam("EXCLUSIVE_EXECUTION", (Object)TaskDBServiceUtils.isExclusiveExecution(taskTypeEnum)), new DBParam("LAST_STATUS_CHANGE", (Object)currentDate)});
        return TaskJson.toTaskJson(task);
    }

    public static TaskJson delegateTaskToNode(TaskDBService taskDBService, int taskId, String electedNode) throws NoSuchTaskException {
        return taskDBService.updateTask(TaskJson.builder().id(taskId).electedNode(electedNode).status(TaskStatusEnum.DELEGATED).build());
    }

    public static TaskJson updateTaskStatus(TaskDBService taskDBService, int taskId, TaskStatusEnum status) throws NoSuchTaskException {
        return taskDBService.updateTask(TaskJson.builder().id(taskId).status(status).build());
    }

    public static TaskJson applyTaskUpdate(ActiveObjects activeObjects, @Nonnull TaskJson update) throws NoSuchTaskException {
        Task task = TaskDBServiceUtils.getTaskInterface(activeObjects, update.getId());
        if (task == null) {
            throw new NoSuchTaskException(update.getId());
        }
        task.setTimeStarted(update.getTimeStarted() == null ? task.getTimeStarted() : update.getTimeStarted());
        task.setTimeEnded(update.getTimeEnded() == null ? task.getTimeEnded() : update.getTimeEnded());
        task.setTaskStatus(update.getStatus() == null ? task.getTaskStatus() : update.getStatus().name());
        task.setSuccess(update.getSuccess() <= 0 ? task.getSuccess() : update.getSuccess());
        task.setFailed(update.getFailed() <= 0 ? task.getFailed() : update.getFailed());
        task.setSkipped(update.getSkipped() <= 0 ? task.getSkipped() : update.getSkipped());
        task.setWarning(update.getWarning() <= 0 ? task.getWarning() : update.getWarning());
        task.setTotalCount(update.getTotalCount() <= 0 ? task.getTotalCount() : update.getTotalCount());
        task.setElectedNode(update.getElectedNode() == null ? task.getElectedNode() : update.getElectedNode());
        task.setManagerNode(update.getManagerNode() == null ? task.getManagerNode() : update.getManagerNode());
        if (TaskDBServiceUtils.shouldUpdateStatusLastChange(update)) {
            task.setLastStatusChange(new Date());
        }
        task.save();
        return TaskJson.toTaskJson(task);
    }

    public static void assignNodeAsManager(TaskDBService taskDBService, int taskId, String managerNode) throws NoSuchTaskException {
        taskDBService.updateTask(TaskJson.builder().id(taskId).managerNode(managerNode).build());
    }

    private static Task getTaskInterface(ActiveObjects activeObjects, int taskId) {
        return (Task)activeObjects.get(Task.class, (Object)taskId);
    }

    private static boolean shouldUpdateStatusLastChange(@Nonnull TaskJson payload) {
        return payload.getStatus() != null || payload.getSuccess() > 0 || payload.getFailed() > 0 || payload.getWarning() > 0 || payload.getSkipped() > 0 || payload.getTotalCount() > 0 || payload.getManagerNode() != null || payload.getElectedNode() != null;
    }

    private static boolean isExclusiveExecution(TaskTypeEnum taskTypeEnum) {
        return !taskTypeEnum.equals((Object)TaskTypeEnum.GEN_STATISTICS_CSV) && !taskTypeEnum.equals((Object)TaskTypeEnum.PARALLEL_TEST);
    }
}

