/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.json.externalapi;

import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIResponse;
import co.uk.automationconsultants.compliance.json.externalapi.ResponseStatus;
import co.uk.automationconsultants.compliance.utils.DataUtils;
import co.uk.automationconsultants.compliance.utils.DateUtils;
import co.uk.automationconsultants.compliance.utils.ExtractionUtils;
import co.uk.automationconsultants.compliance.utils.StringUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomResponseDeserializer
extends JsonDeserializer<ExternalAPIResponse> {
    private final Logger log = LoggerFactory.getLogger(ExtractionUtils.class);
    private JsonNode node;

    private List<String> getIncorrectFieldNames(List<String> expected, Iterator<String> actual) {
        ArrayList<String> incorrectFieldNames = new ArrayList<String>();
        while (actual.hasNext()) {
            String actualString = actual.next();
            if (expected.contains(actualString)) continue;
            incorrectFieldNames.add(actualString);
        }
        return incorrectFieldNames;
    }

    private List<String> getMissingFieldNames(Iterator<String> actual, ArrayList<String> expected) {
        ArrayList<String> actualList = new ArrayList<String>();
        while (actual.hasNext()) {
            String actualString = actual.next();
            actualList.add(actualString);
        }
        expected.removeAll(actualList);
        return expected;
    }

    private void checkIncorrectFieldNames(List<String> incorrectFieldNames) throws IOException {
        if (!incorrectFieldNames.isEmpty()) {
            String msg = String.format("Unexpected field %s found in response.", incorrectFieldNames);
            throw new IOException(msg);
        }
    }

    private boolean checkMissingExpected(List<String> missingExpected) throws IOException {
        boolean isErrorMissing = missingExpected.remove("errorMessage");
        if (!missingExpected.isEmpty()) {
            throw new IOException(String.format("Missing Field(s); %s are required field(s).", missingExpected));
        }
        return isErrorMissing;
    }

    private Optional<List<String>> strictlyDeserializeToStringList(Iterator<JsonNode> arrayNode) {
        List<JsonNode> asList = DataUtils.toList(arrayNode);
        if (asList.stream().allMatch(JsonNode::isTextual)) {
            return Optional.of(asList.stream().map(JsonNode::asText).collect(Collectors.toList()));
        }
        return Optional.empty();
    }

    private ResponseStatus getStatus() throws IOException {
        try {
            if (this.node.get("status").isTextual()) {
                String statusString = this.node.get("status").asText().toUpperCase();
                return ResponseStatus.valueOf(statusString);
            }
            throw new IOException("The status field returned is not a String.");
        }
        catch (IllegalArgumentException e) {
            throw new IOException("The status field returned does not equal SUCCESS or FAIL.");
        }
    }

    private String getErrorMessage(boolean isErrorMissing) throws IOException {
        if (!isErrorMissing) {
            if (this.node.get("errorMessage").isTextual()) {
                return this.node.get("errorMessage").asText();
            }
            if (this.node.get("errorMessage").isNull()) {
                return null;
            }
            throw new IOException("The errorMessage field returned is not a String.");
        }
        return null;
    }

    private boolean getIsDetected() throws IOException {
        if (this.node.get("isDetected").isBoolean()) {
            return this.node.get("isDetected").asBoolean();
        }
        if (this.node.get("isDetected").isTextual()) {
            String isDetected = this.node.get("isDetected").asText();
            if (isDetected.equalsIgnoreCase("true") || isDetected.equalsIgnoreCase("false")) {
                return Boolean.parseBoolean(isDetected);
            }
            throw new IOException(String.format("The value returned for isDetected, %s, cannot be parsed as a boolean object.", isDetected));
        }
        throw new IOException("The value returned for isDetected cannot be parsed as a boolean object.");
    }

    private Date getDetectionDate() throws IOException {
        String CANT_BE_PARSED = "The detectionDate value provided cannot be parsed. Provide a Long representing a Unix timestamp in milliseconds, or a String ISO8601 date in the format of \"yyyy-MM-ddTHH:mm:ss.SSSZ\".";
        try {
            if (this.node.get("detectionDate").isIntegralNumber()) {
                return new Date(this.node.get("detectionDate").asLong());
            }
            if (this.node.get("detectionDate").isTextual()) {
                return DateUtils.parseIso8601DateString(this.node.get("detectionDate").asText());
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("The detectionDate value provided is not a Unix Epoch time stamp (milliseconds).");
        }
        catch (IllegalArgumentException | ParseException e) {
            throw new IOException("The detectionDate value provided cannot be parsed. Provide a Long representing a Unix timestamp in milliseconds, or a String ISO8601 date in the format of \"yyyy-MM-ddTHH:mm:ss.SSSZ\".");
        }
        throw new IOException("The detectionDate value provided cannot be parsed. Provide a Long representing a Unix timestamp in milliseconds, or a String ISO8601 date in the format of \"yyyy-MM-ddTHH:mm:ss.SSSZ\".");
    }

    private List<String> getDetectedText() throws IOException {
        List<String> detectedText;
        if (this.node.get("detectedText").isArray()) {
            detectedText = this.strictlyDeserializeToStringList(this.node.get("detectedText").getElements()).orElseThrow(() -> new IOException("The detectedText list provided contains values which are not strings."));
        } else if (this.node.get("detectedText").isTextual()) {
            detectedText = StringUtils.parseStringToStringList(this.node.get("detectedText").asText());
        } else {
            throw new IOException("Could not format the detectedText object. The expected format is a list of strings, String[]. If your API is unable to send a list of Strings, a String in the format of a list is also accepted, e.g. \"['string1', 'string2']\".");
        }
        if (detectedText.stream().anyMatch(s -> s.trim().isEmpty())) {
            throw new IOException("Provided detectedText list contains empty strings. If no text has been detected, return a detectedText list with no elements.");
        }
        return detectedText;
    }

    private ExternalAPIResponse runDeserializer() throws IOException {
        ArrayList<String> expectedFieldNames = new ArrayList<String>(Arrays.asList("status", "errorMessage", "isDetected", "detectedText", "detectionDate"));
        List<String> incorrectFieldNames = this.getIncorrectFieldNames(expectedFieldNames, this.node.getFieldNames());
        List<String> missingExpected = this.getMissingFieldNames(this.node.getFieldNames(), expectedFieldNames);
        this.checkIncorrectFieldNames(incorrectFieldNames);
        boolean isErrorMissing = this.checkMissingExpected(missingExpected);
        ResponseStatus status = this.getStatus();
        String errorMessage = this.getErrorMessage(isErrorMissing);
        boolean isDetected = this.getIsDetected();
        Date detectionDate = this.getDetectionDate();
        List<String> detectedText = this.getDetectedText();
        if (isDetected && detectedText.isEmpty()) {
            throw new IOException("The isDetected field is true, but no detected strings are provided in the detectedText list.");
        }
        if (!isDetected && !detectedText.isEmpty()) {
            throw new IOException("The isDetected field is false, but detected strings have been provided in the detectedText list.");
        }
        return new ExternalAPIResponse(status, errorMessage, isDetected, detectedText, detectionDate);
    }

    public ExternalAPIResponse deserialize(JsonParser jp, DeserializationContext deserializationContext) {
        try {
            this.node = jp.getCodec().readTree(jp);
            return this.runDeserializer();
        }
        catch (IOException e) {
            return new ExternalAPIResponse(ResponseStatus.FAIL, e.getMessage(), false, new ArrayList<String>(), new Date());
        }
    }
}

