/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task.delegation;

import co.uk.automationconsultants.compliance.exception.task.NoSuchTaskException;
import co.uk.automationconsultants.compliance.helper.ClusterHelper;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.TaskScanner;
import co.uk.automationconsultants.compliance.task.event.SingleNodeNotificationEvent;
import co.uk.automationconsultants.compliance.utils.task.TaskDBServiceUtils;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import java.io.NotActiveException;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="taskDelegationService")
public class TaskDelegationService {
    @ComponentImport
    private final ClusterManager clusterManager;
    private final TaskDBService taskDBService;
    private final Random random = new Random();
    private static final Logger log = LoggerFactory.getLogger(TaskDelegationService.class);
    private final ClusterHelper clusterHelper;

    @Inject
    public TaskDelegationService(ClusterManager clusterManager, TaskDBService taskDBService, ClusterHelper clusterHelper) {
        this.clusterManager = clusterManager;
        this.taskDBService = taskDBService;
        this.clusterHelper = clusterHelper;
    }

    @Nullable
    public ClusterNodeInformation delegateTask(int taskId) throws NullArgumentException, IOException, NoSuchTaskException {
        TaskJson task = this.taskDBService.getTask(taskId);
        if (task == null) {
            throw new NullArgumentException("Received null task object for delegation.");
        }
        ClusterNodeInformation currentNode = this.clusterManager.getThisNodeInformation();
        ClusterNodeInformation electedNode = null;
        if (currentNode != null) {
            if (!task.getManagerNode().equals(currentNode.getAnonymizedNodeIdentifier())) {
                throw new IllegalStateException(String.format("Node %s is not declared as manager for task %d. Aborting delegation", currentNode.getAnonymizedNodeIdentifier(), task.getId()));
            }
            ClusterNodeInformation randomNode = this.getRandomRunningClusterNode();
            log.debug("Received Elected Node: {}", (Object)randomNode.getAnonymizedNodeIdentifier());
            electedNode = randomNode;
        }
        TaskDBServiceUtils.delegateTaskToNode(this.taskDBService, task.getId(), electedNode != null ? electedNode.getAnonymizedNodeIdentifier() : "NO_CLUSTER");
        return electedNode;
    }

    public void delegateTask(int taskId, TaskScanner taskScanner) throws NullArgumentException, NoSuchTaskException, IOException {
        ClusterNodeInformation electedNode = this.delegateTask(taskId);
        log.debug("Alerting Task Scanner");
        if (electedNode == null || this.clusterManager.getClusterInformation().getMemberCount() <= 1) {
            taskScanner.alertScanner();
        } else {
            log.debug("Attempting to publish event on clustered system");
            this.clusterManager.publishEvent((ConfluenceEvent)new SingleNodeNotificationEvent(electedNode.getAnonymizedNodeIdentifier()));
        }
    }

    private ClusterNodeInformation getRandomRunningClusterNode() throws NotActiveException {
        List<ClusterNodeInformation> acceptedNodes = this.clusterHelper.getRunningNodes();
        if (acceptedNodes.isEmpty()) {
            throw new NotActiveException("No valid running Cluster node found");
        }
        return acceptedNodes.get(this.random.nextInt(acceptedNodes.size()));
    }
}

