/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.json.analysis;

import co.uk.automationconsultants.compliance.entity.analysis.ExtractionResult;
import co.uk.automationconsultants.compliance.json.analysis.PageJson;
import co.uk.automationconsultants.compliance.json.analysis.SpaceJson;
import co.uk.automationconsultants.compliance.json.capture.ExtractionJson;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AnalysisResultJson {
    @XmlElement(name="id")
    public Integer id;
    @XmlElement(name="page")
    public PageJson page;
    @XmlElement(name="extraction")
    public ExtractionJson extraction;
    @XmlElement(name="space")
    public SpaceJson space;
    @XmlElement(name="text")
    public String text;
    @XmlElement(name="detectedOn")
    public Date detectedOn;
    @XmlElement(name="active")
    public boolean active;

    public static List<AnalysisResultJson> mapAll(SpaceManager spaceManager, PageManager pageManager, ExtractionResult[] results) {
        return Arrays.stream(results).map(extractionResult -> AnalysisResultJson.map(spaceManager, pageManager, extractionResult)).collect(Collectors.toList());
    }

    public static AnalysisResultJson map(SpaceManager spaceManager, PageManager pageManager, ExtractionResult extraction) {
        return new AnalysisResultJson(ExtractionJson.map(extraction.getExtractionEntity()), SpaceJson.map(spaceManager, extraction.getSpaceId()), extraction.getCapturedText(), extraction.getDetectionDate(), extraction.isActive(), PageJson.map(pageManager, extraction.getPageId(), extraction.getPageVersion()), extraction.getID());
    }

    public AnalysisResultJson() {
    }

    public AnalysisResultJson(ExtractionJson extraction, SpaceJson space, String text, Date detectedOn, boolean active, PageJson page, Integer id) {
        this.extraction = extraction;
        this.space = space;
        this.text = text;
        this.detectedOn = detectedOn;
        this.active = active;
        this.page = page;
        this.id = id;
    }

    public ExtractionJson getExtraction() {
        return this.extraction;
    }

    public void setExtraction(ExtractionJson extraction) {
        this.extraction = extraction;
    }

    public SpaceJson getSpace() {
        return this.space;
    }

    public void setSpace(SpaceJson space) {
        this.space = space;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Date getDetectedOn() {
        return this.detectedOn;
    }

    public void setDetectedOn(Date detectedOn) {
        this.detectedOn = detectedOn;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public PageJson getPage() {
        return this.page;
    }

    public void setPage(PageJson page) {
        this.page = page;
    }
}

