/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.listener;

import co.uk.automationconsultants.compliance.service.AnalysisService;
import co.uk.automationconsultants.compliance.service.maintenance.ContentPropertyMaintenanceService;
import co.uk.automationconsultants.compliance.service.maintenance.ExtractionResultMaintenanceService;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.Page;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named(value="analysisListener")
public class AnalysisListener
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AnalysisListener.class);
    @ComponentImport
    protected EventPublisher eventPublisher;
    private final AnalysisService analysisService;
    private final ExtractionResultMaintenanceService extractionResultMaintenanceService;
    private final ContentPropertyMaintenanceService contentPropertyMaintenanceService;

    @Inject
    public AnalysisListener(EventPublisher eventPublisher, AnalysisService analysisService, ExtractionResultMaintenanceService extractionResultMaintenanceService, ContentPropertyMaintenanceService contentPropertyMaintenanceService) {
        this.eventPublisher = eventPublisher;
        this.analysisService = analysisService;
        this.extractionResultMaintenanceService = extractionResultMaintenanceService;
        this.contentPropertyMaintenanceService = contentPropertyMaintenanceService;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void pageCreated(PageCreateEvent event) {
        Page page = event.getPage();
        String body = page.getBodyContent().getBody();
        log.debug(body);
        this.analysisService.processPageRealTime(page, true);
    }

    @EventListener
    public void pageRemoved(PageRemoveEvent event) {
        Page page = event.getPage();
        this.analysisService.onDeletePage(page);
    }

    @EventListener
    public void pageTrashed(PageTrashedEvent event) {
        Page page = event.getPage();
        this.analysisService.onTrashPage(page);
    }

    @EventListener
    public void pageRestored(PageRestoreEvent event) {
        Page page = event.getPage();
        this.analysisService.onRestorePage(page);
    }

    @EventListener
    public void pageMoved(PageMoveEvent event) {
        if (event.isMovedSpace()) {
            Page page = event.getPage();
            this.extractionResultMaintenanceService.updateExtractionResultSpaceId(page, page.getSpace().getId());
            this.contentPropertyMaintenanceService.reAddComplianceContentProperties(page);
        }
    }

    @EventListener
    public void pageUpdated(PageUpdateEvent event) {
        Page page = event.getPage();
        String body = page.getBodyContent().getBody();
        log.debug(body);
        this.analysisService.processPageRealTime(page, true);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

