/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task.maintenance;

import co.uk.automationconsultants.compliance.helper.ClusterHelper;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.maintenance.TaskMaintenanceParams;
import co.uk.automationconsultants.compliance.utils.StringUtils;
import co.uk.automationconsultants.compliance.utils.task.TaskMaintenanceUtils;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMaintenanceParamsFactory {
    private static final Logger logger = LoggerFactory.getLogger(TaskMaintenanceParamsFactory.class);

    private TaskMaintenanceParamsFactory() {
    }

    public static TaskMaintenanceParams initialiseMaintenanceParams(String currentNodeId, TaskDBService taskDBService, List<TaskJson> tasks, ClusterHelper clusterHelper, TransactionTemplate transactionTemplate) {
        Map<String, List<TaskJson>> runningTasksPerNode = TaskMaintenanceParamsFactory.initialiseRunningTasksPerNode(tasks);
        Set<String> nodeIds = TaskMaintenanceUtils.getNodeIdsFromTasks(tasks);
        if (logger.isDebugEnabled()) {
            logger.debug("All Node Ids: {}", (Object)String.join((CharSequence)",", nodeIds));
        }
        Set<String> deadNodeIds = clusterHelper.getDeadNodeIds(nodeIds);
        TaskMaintenanceParamsFactory.printDebugLog("Dead Node Ids: {}", String.join((CharSequence)",", deadNodeIds));
        Set<String> aliveNodeIds = clusterHelper.getRunningNodeIds(nodeIds);
        TaskMaintenanceParamsFactory.printDebugLog("Alive Node Ids: {}", String.join((CharSequence)",", aliveNodeIds));
        Map<String, Date> howLongItHasBeenMap = TaskMaintenanceParamsFactory.initialiseHowLongItHasBeenMap(taskDBService, aliveNodeIds, transactionTemplate);
        return new TaskMaintenanceParams(currentNodeId, deadNodeIds, aliveNodeIds, howLongItHasBeenMap, runningTasksPerNode);
    }

    private static void printDebugLog(String message, Object ... values) {
        if (logger.isDebugEnabled()) {
            logger.debug(message, values);
        }
    }

    private static Map<String, List<TaskJson>> initialiseRunningTasksPerNode(List<TaskJson> unfinishedTasks) {
        return unfinishedTasks.stream().filter(task -> task.getStatus().equals((Object)TaskStatusEnum.IN_PROGRESS)).collect(Collectors.groupingBy(TaskJson::getElectedNode));
    }

    @Nullable
    private static Date getHowLongItHasBeenSinceLastChange(TaskDBService taskDBService, String nodeId, TransactionTemplate transactionTemplate) {
        List<TaskStatusEnum> statuses = Arrays.asList(TaskStatusEnum.IN_PROGRESS, TaskStatusEnum.CANCELLED, TaskStatusEnum.SUCCESS, TaskStatusEnum.SUCCESS_WITH_ERRORS, TaskStatusEnum.FAILED, TaskStatusEnum.TERMINATED);
        List<String> statusStrings = statuses.stream().map(Enum::name).collect(Collectors.toList());
        Query query = Query.select().where("ELECTED_NODE = ? AND TASK_STATUS IN " + StringUtils.generateCommaSepListWrappedInBrackets(statusStrings), new Object[]{nodeId}).order("LAST_STATUS_CHANGE DESC").limit(1);
        List tasks = (List)transactionTemplate.execute(() -> taskDBService.runQueryOnTaskTable(query));
        return tasks.isEmpty() ? null : ((TaskJson)tasks.get(0)).getLastStatusChange();
    }

    private static Map<String, Date> initialiseHowLongItHasBeenMap(TaskDBService taskDBService, Set<String> nodeIds, TransactionTemplate transactionTemplate) {
        HashMap<String, Date> howLongItHasBeenMap = new HashMap<String, Date>();
        for (String nodeId : nodeIds) {
            Date howLongItHasBeen = TaskMaintenanceParamsFactory.getHowLongItHasBeenSinceLastChange(taskDBService, nodeId, transactionTemplate);
            if (howLongItHasBeen == null) continue;
            howLongItHasBeenMap.put(nodeId, howLongItHasBeen);
        }
        return howLongItHasBeenMap;
    }
}

