/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.exception.externalapi.ExternalAPIResponseException;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigJson;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigPayload;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIConfigReadOnly;
import co.uk.automationconsultants.compliance.json.externalapi.ExternalAPIRequest;
import co.uk.automationconsultants.compliance.rest.AdminPermissionHelper;
import co.uk.automationconsultants.compliance.service.externalapi.ExternalAPIService;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/externalapi")
public class ExternalAPIConfigRest {
    private final ExternalAPIService externalAPIService;
    private final AdminPermissionHelper adminPermissionHelper;

    @Inject
    public ExternalAPIConfigRest(ExternalAPIService externalAPIService, AdminPermissionHelper adminPermissionHelper) {
        this.externalAPIService = externalAPIService;
        this.adminPermissionHelper = adminPermissionHelper;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateConfig(@Context HttpServletRequest request, ExternalAPIConfigPayload payload) {
        if (!this.adminPermissionHelper.isConfluenceAdmin(request)) {
            return Response.status((int)403).build();
        }
        try {
            if (this.externalAPIService.hasBeenConfigured()) {
                ExternalAPIConfigReadOnly config = this.externalAPIService.updateAuthConfigReadOnly(payload);
                return Response.ok((Object)config).build();
            }
            ExternalAPIConfigJson config = this.externalAPIService.createConfig(payload);
            return Response.ok((Object)config.toReadOnly()).build();
        }
        catch (GeneralSecurityException e) {
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response getConfig(@Context HttpServletRequest request) {
        if (!this.adminPermissionHelper.isConfluenceAdmin(request)) {
            return Response.status((int)403).build();
        }
        ExternalAPIConfigReadOnly config = this.externalAPIService.getAuthConfigReadOnly();
        if (config == null) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)this.externalAPIService.getAuthConfigReadOnly()).build();
    }

    @POST
    @Path(value="/request")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendRestRequest(ExternalAPIRequest request) {
        try {
            return Response.ok((Object)this.externalAPIService.runExternalAPIRequest(request)).build();
        }
        catch (ExternalAPIResponseException e) {
            return Response.status((int)e.getStatusCode()).header("API-ERROR-MESSAGE", (Object)e.getMessage()).entity((Object)e.getResponseBody()).build();
        }
        catch (Exception e) {
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }
}

