/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.condition;

import co.uk.automationconsultants.compliance.cache.GlobalSettingsCache;
import co.uk.automationconsultants.compliance.cache.SpaceSettingsCache;
import co.uk.automationconsultants.compliance.entity.SettingEntity;
import co.uk.automationconsultants.compliance.json.level.LevelsJson;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.atlassian.user.User;
import java.util.Map;
import javax.inject.Inject;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceSidebarCondition
implements Condition {
    private final GlobalSettingsCache globalSettingsCache;
    private static final Logger log = LoggerFactory.getLogger(SpaceSidebarCondition.class);
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final ActiveObjects activeObjects;
    private final SpaceSettingsCache spaceSettingsCache;

    @Inject
    public SpaceSidebarCondition(GlobalSettingsCache globalSettingsCache, SpacePermissionManager spacePermissionManager, PermissionManager permissionManager, ActiveObjects activeObjects, SpaceSettingsCache spaceSettingsCache) {
        this.globalSettingsCache = globalSettingsCache;
        this.spacePermissionManager = spacePermissionManager;
        this.permissionManager = permissionManager;
        this.activeObjects = activeObjects;
        this.spaceSettingsCache = spaceSettingsCache;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Space space = (Space)context.get("space");
        if (space == null) {
            return false;
        }
        LevelsJson globalSettings = this.globalSettingsCache.getGlobalSettings();
        try {
            SettingEntity[] settingsList = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
            SettingEntity settings = settingsList[0];
            boolean globallyControlled = Boolean.TRUE.equals(settings.getClassiGloballyControlled());
            if (globallyControlled && Boolean.FALSE.equals(settings.isClassificationEnabled())) {
                return false;
            }
            if (!globallyControlled && !this.spaceSettingsCache.get(space.getKey()).isEnabled()) {
                return false;
            }
            ConfluenceUser user = (ConfluenceUser)context.get("user");
            boolean hasSpacePermission = this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)user);
            boolean isGlobalAdmin = this.permissionManager.isConfluenceAdministrator((User)user);
            return isGlobalAdmin || globalSettings.getSpaceData() != false && hasSpacePermission || globalSettings.getSpaceLevel() != false && hasSpacePermission;
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            return false;
        }
    }
}

